package jsquid.xml;

import jsquid.display.JLinkButton;

/***
 * 
 * @author martin
 *
 *Builds a hyperlink out of three parts
 */
public class LinkURL {

	//the name of the url
	private String linkName = null;
	//representing the begin of an URL 
	private String urlBegin = "";
	//representing the end of the URL 
	private String urlEnd = "";
	//representing the middle part of an URL - in our case mostly a protein id
	private String linkID = "";
	
	public LinkURL(String linkName, String urlBegin, String urlEnd) {
		if (urlBegin != null)
			this.urlBegin = urlBegin;
		if (urlEnd != null)
			this.urlEnd = urlEnd;
		this.linkName = linkName;
	}
	
	public void setLinkID(String id) {
		this.linkID = id;
	}
	
	public String getLinkName() {
		if (linkName != null)
			return linkName;
		else
			return JLinkButton.makePrettyURLName(this.toString());
	}
	
	public String toString() {
		return urlBegin+linkID+urlEnd;
	}
}
