/**
 * JSquidGraph.java
 */
package jsquid.graph;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

import medusa.MedusaSettings;
import medusa.graph.Edge;
import medusa.graph.Graph;

/**
 * @author sanjit
 * Extension of Medusa Graph class for collapsing
 */
public class JSquidGraph extends Graph {

	private Collapse collapse = null;
	private ArrayList emptyOrganelleGroupNodes = null;
	private ArrayList nonConfEdges = new ArrayList();
	
	/**
	 * collapse Nodes which are selected for both singleEdges and edges
	 */
	public void collapseNodes(boolean isDetailedGraph){
		if(collapse == null)
			collapse = new Collapse(singleEdges, edges, nodes, uniqueEdges, isDetailedGraph);
		collapse.collapseNodes();

		//sortEdgeList(); //Important for Confidence Slider
	}

	/**
	 * expand Node with the name @param toExpandNode
	 * @throws Exception Data is corrupt
	 */
	public void expandNode(String toExpandNode) throws Exception{
		collapse.expandNode(toExpandNode);
		
		//sortEdgeList(); //Important for Confidence Slider
	}

	public void setEmptyOrganelleGroupNodes(ArrayList emptyOrganelleGroupNodes) {
		this.emptyOrganelleGroupNodes = emptyOrganelleGroupNodes;
	}

	public ArrayList getEmptyOrganelleGroupNodes() {
		return emptyOrganelleGroupNodes;
	}
	
	public void findNonConfEdges(MedusaSettings nonConfSettings) {
		Hashtable nonConfCheckedTable = null;
		if (nonConfSettings != null){
			nonConfCheckedTable = nonConfSettings.getCheckedTable(); 
		}
		if (nonConfCheckedTable != null) {
			for (Iterator itor = edges.iterator(); itor.hasNext();) {
				Edge e = (Edge)itor.next();
				if (nonConfCheckedTable.containsKey(new Integer(e.getType()))) {
					e.setConfidenceEdge(false);		
					nonConfEdges.add(e);
				}
			}
		}
		//Collections.sort(nonConfEdges);
	}

	public void setNonConfEdges(ArrayList nonConfEdges) {
		this.nonConfEdges = nonConfEdges;
	}

	public ArrayList getNonConfEdges() {
		return nonConfEdges;
	}
	
}
