/**
 * EdgeMap.java
 */
package jsquid.graph;

import java.util.ArrayList;
import java.util.HashMap;

import medusa.graph.Edge;
import medusa.graph.Graph;

/**
 * @author sanjit
 * Map of edges. key name of node, value list of neighbours
 */
public class EdgeMap {

	private HashMap completeEdgeMatrix;
	
	private Graph graph;
	
	public EdgeMap(){
		completeEdgeMatrix = new HashMap();
	}
	
	public EdgeMap(Graph graph){
		this();
		this.graph = graph;
	}
	
	/**
	 * Creates a EdgeMatrix of all edges in the graph
	 */
	public void createCompleteEdgeMatrix(){
		ArrayList edges = new ArrayList(graph.getEdges());

		while(edges.size() > 0){
			Edge e = (Edge) edges.get(0);

			ArrayList neighboursNode1 = new ArrayList();
			ArrayList neighboursNode2 = new ArrayList();

			if (completeEdgeMatrix.containsKey(e.n1)) {
				neighboursNode1 = (ArrayList) completeEdgeMatrix.get(e.n1);
			}
			if (completeEdgeMatrix.containsKey(e.n2)) {		
				neighboursNode2 = (ArrayList) completeEdgeMatrix.get(e.n2);
			}

			neighboursNode1.add(e);
			neighboursNode2.add(e);

			completeEdgeMatrix.put(e.n1, neighboursNode1);
			completeEdgeMatrix.put(e.n2, neighboursNode2);
			edges.remove(0);
		}
	}
	
	/**
	 * Creates a EdgeMatrix of @param listEdges
	 */
	public void createCompleteEdgeMatrix(ArrayList listEdges){
		ArrayList edges = new ArrayList(listEdges);

		while(edges.size() > 0){
			Edge e = (Edge) edges.get(0);

			ArrayList neighboursNode1 = new ArrayList();
			ArrayList neighboursNode2 = new ArrayList();

			if (completeEdgeMatrix.containsKey(e.n1)) {
				neighboursNode1 = (ArrayList) completeEdgeMatrix.get(e.n1);
			}
			if (completeEdgeMatrix.containsKey(e.n2)) {		
				neighboursNode2 = (ArrayList) completeEdgeMatrix.get(e.n2);
			}

			neighboursNode1.add(e);
			neighboursNode2.add(e);

			completeEdgeMatrix.put(e.n1, neighboursNode1);
			completeEdgeMatrix.put(e.n2, neighboursNode2);
			edges.remove(0);
		}
	}

	/**
	 * @return the completeEdgeMatrix
	 */
	public final HashMap getCompleteEdgeMatrix() {
		return completeEdgeMatrix;
	}

}
