/**
 * CollapsedData.java
 */
package jsquid.graph;

import java.util.HashMap;

import medusa.graph.Node;

/**
 * @author sanjit 
 * Container class for CollapsedData
 * A CollapsedNodes saves all the nodes which are in this node.
 * In Nodes there are fully expanded (no child collapsed nodes)
 * In DisplayNodes you will find the visible nodes (also child collapsed nodes)
 */
public class CollapsedData {

	private HashMap nodes; // All nodes inclusive all child nodes (completly
							// expanded child collapsed nodes)

	private HashMap displayNodes; // Only the nodes which were displayed

	private boolean visible; // If Collapsed Node is visible

	public CollapsedData() {
		nodes = new HashMap();
		displayNodes = new HashMap();
		visible = true;
	}

	/**
	 * @return the nodes
	 */
	public HashMap getNodes() {
		return nodes;
	}

	/**
	 * @return size of nodes map
	 */
	public int getNodeSize() {
		return nodes.size();
	}

	/**
	 * @return the visible
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * @param visible
	 *            the visible to set
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

	/**
	 * adds a node to the nodes map
	 * @param key name of node
	 * @param n node object
	 */
	public void addNode(String key, Node n) {
		nodes.put(key, n);
	}

	/**
	 * @return the displayNodes
	 */
	public HashMap getDisplayNodes() {
		return displayNodes;
	}

	/**
	 * add a node to the display map
	 * @param key name of node
	 * @param n node object
	 */
	public void addDisplayNode(String key, Node n) {
		displayNodes.put(key, n);
	}

}
