/**
 * XMLSAXConverter.java
 */
package jsquid.export.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import medusa.MedusaSettings;
import medusa.graph.Graph;

/**
 * @author sanjit
 * SAX Implementation of a XML Converter
 */
public abstract class XMLSAXConverter implements XMLConverter {

	private File file;
	
	private Graph graph;
	
	protected TransformerHandler hd = null;
	
	private MedusaSettings settings;
	
	private boolean prettyEdge;
		
	public XMLSAXConverter(File input, Graph graph, MedusaSettings settings, boolean prettyEdge) {
		this.file = input;
		this.graph = graph;
		this.settings = settings;
		this.prettyEdge = prettyEdge;
	}

	//This is a template function
	public final void convert() throws Exception {
		//initalisize SAX Transformer	
		SAXTransformerFactory tf = (SAXTransformerFactory) SAXTransformerFactory.newInstance();
		hd = tf.newTransformerHandler();
		Transformer serializer = hd.getTransformer();
		serializer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		serializer.setOutputProperty(OutputKeys.METHOD,"xml");
		serializer.setOutputProperty(OutputKeys.INDENT, "yes");
		
		OutputStream stream = null;
		if(file != null)
			stream = new FileOutputStream(file);

		StreamResult streamResult = new StreamResult(stream);
		hd.setResult(streamResult);
		
		hd.startDocument();
		
		//Start converting
		doConvert();

		hd.endDocument();
		
		stream.close();
	}
	
	protected abstract void doConvert() throws Exception;

	/**
	 * @return the graph
	 */
	protected final Graph getGraph() {
		return graph;
	}

	/**
	 * @return the settings
	 */
	protected final MedusaSettings getSettings() {
		return settings;
	}

	/**
	 * @return the prettyEdge
	 */
	protected final boolean isPrettyEdge() {
		return prettyEdge;
	}

}
