/**
 * PictureExporter.java
 */
package jsquid.export.picture;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

import medusa.display.BasicGraphPanel;


/**
 * @author sanjit
 * Abstract class PictureExporter. Implement if you want to export as a picture.
 */
public abstract class PictureExporter {

	private BasicGraphPanel panel;
	
	private File file;

	public PictureExporter(File input, BasicGraphPanel panel) {
		this.file = input;
		this.panel = panel;
	}
	
	/**
	 * @return the panel
	 */
	protected final BasicGraphPanel getPanel() {
		return panel;
	}
	
	/**
	 * @return the file
	 */
	protected final File getFile() {
		return file;
	}

	// This is a template function
	public final void export() throws IOException {

		
		
		OutputStream stream = doExport();

		stream.close();
	}

	protected abstract OutputStream doExport() throws IOException;
}
