/**
 * ExportToGIF.java
 */
package jsquid.export.picture;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;

import medusa.display.BasicGraphPanel;



/**
 * @author sanjit
 * Implementation of PictureExporter for GIF Format
 */
public class ExportToGIF extends PictureExporter {

	public ExportToGIF(File input, BasicGraphPanel panel) {
		super(input, panel);
	}

	protected OutputStream doExport() throws IOException {
		BufferedImage awtImage = new BufferedImage(getPanel().getWidth(), getPanel().getHeight(),
				BufferedImage.TYPE_INT_ARGB);
		Graphics2D g = awtImage.createGraphics();
		g.setColor(Color.white);
		g.fillRect(0, 0, getPanel().getWidth(), getPanel().getHeight());

		getPanel().paintNet(g);

		OutputStream stream = null;
		if(getFile() != null)
			stream = new FileOutputStream(getFile());

		ImageIO.write(awtImage, "gif", stream);
		
		return stream;
	}

}
