/**
 * XGMMLFilter.java
 */
package jsquid.export.filters;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import jsquid.export.Utils;

/**
 * @author sanjit
 * FileFilter for XGMML (.xgmml and .xml)
 */
public class XGMMLFilter extends FileFilter {

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
	 */
	public boolean accept(File f) {
		if(f.isDirectory()){
			return true;
		}
		
		String extension = Utils.getExtension(f);
		if (extension != null) {
			if (extension.equals(Utils.XML) || extension.equals(Utils.XGMML))
				return true;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#getDescription()
	 */
	public String getDescription() {
		return ".xml, .xgmml";
	}

}
