/**
 * Utils.java
 */
package jsquid.export;

import java.io.File;

/**
 * @author sanjit
 * Util Class for Exporting. get or Checks Extensions.
 */
public class Utils {
	public final static String GIF = "gif";
	public final static String EPS = "eps";
	public final static String XML = "xml";
	public final static String XGMML = "xgmml";
	
	   /*
     * Get the extension of a file.
     */
    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }

    /**
     * Checks Extension of File. If Extension missing add correct extension
     * @param selectedFile
     * @param type
     * @return new File
     */
	public static File checkExtension(File selectedFile, String type) {
		String ext = getExtension(selectedFile);
		File f = selectedFile;
		if(ext == null || !ext.equals(type))
			f = new File(selectedFile.getPath() + "." + type);
		return f;
	}
}
