/**
 * DrawingFactory.java
 */
package jsquid.display.drawing.factory;

import jsquid.display.drawing.PaintStyle;
import jsquid.display.drawing.NormalPaintStyle;
import jsquid.display.drawing.OldPaintStyle;

/**
 * @author sanjit
 * Drawing Factory to create PaintStyles
 */
public class DrawingFactory {

	/* (non-Javadoc)
	 * @see jsquid.display.drawing.factory.IDrawingFactory#create(int)
	 */
	public PaintStyle create(String type) {
	
		if(type.equalsIgnoreCase(DrawingType.NORMALTYPE))
			return new NormalPaintStyle();
		else if(type.equalsIgnoreCase(DrawingType.OLDTYPE))
			return new OldPaintStyle();
		else return null;
	}

}
