/**
 * PaintStyle.java
 */
package jsquid.display.drawing;

import java.awt.Color;
import java.awt.Graphics2D;

import medusa.MedusaSettings;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;

/**
 * @author sanjit Abstract Class for PaintStyles Extend from this class to
 *         create new Styles
 */
public abstract class PaintStyle {

	protected Graph graph;

	protected boolean showConfidence;

	protected boolean prettyEdge;

	protected boolean prettyNode;

	protected boolean labelNode;
	
	protected boolean uniformNodes;

	protected boolean labelEdge;

	protected MedusaSettings settings;
	
	protected MedusaSettings nonConfSettings;

	protected Color basicEdgeColor = Color.darkGray;
	
	protected Color basicNodeColor = Color.lightGray;
	
	protected int basicNodeShape = 0;

	public void setProperties(Graph g, boolean showConfidence,
			boolean prettyNode, boolean prettyEdge, boolean labelNode,
			boolean labelEdge, boolean uniformNodes, MedusaSettings settings,
			MedusaSettings nonConfSettings){
		this.graph = g;
		this.showConfidence = showConfidence;
		this.prettyEdge = prettyEdge;
		this.prettyNode = prettyNode;
		this.settings = settings;
		this.nonConfSettings = nonConfSettings;
		//this.basicEdgeColor = basicEdgeColor;
		this.labelNode = labelNode;
		this.labelEdge = labelEdge;
		this.uniformNodes = uniformNodes;
	}

	public abstract void paintEdge(Graphics2D g, Edge e);

	public abstract void paintNode(Graphics2D g, Node n);
}
