/**
 * OldPaintStyle.java
 */
package jsquid.display.drawing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;

import medusa.display.BasicGraphPanel;
import medusa.display.PaintTools;
import medusa.graph.Edge;
import medusa.graph.Node;

/**
 * @author sanjit and martin 
 * NormalPaintStyle - MedusaStyle
 */
public class OldPaintStyle extends PaintStyle {

	private Color fontColor = java.awt.Color.black;

	private Font nodeFont = new Font("TimesNewRoman", Font.PLAIN, 10);

	private AlphaComposite makeComposite(float alpha) {
		int type = AlphaComposite.SRC_OVER;
		if (alpha > 1.0)
			alpha = 1.0F;
		else if (alpha < 0.0)
			alpha = 0.0F;
		return (AlphaComposite.getInstance(type, alpha));
	}

	public void paintEdge(Graphics2D g, Edge e) {
		Node from = graph.getNode(e.getFromName());
		Node to = graph.getNode(e.n2);
		int x1 = (int) from.getX();
		int y1 = (int) from.getY();
		int x2 = (int) to.getX();
		int y2 = (int) to.getY();

		// handle confidence
		if (showConfidence)
			g.setComposite(makeComposite(e.getConf()));
		g.setPaint(basicEdgeColor);
		// if (e.visible)
		// g.setPaint(Color.red);
		
		//indicates whether the confidence of an edge is a real one
		//and should be displayed or is just for determining the line
		//thickness and therfore should not be displayed. this value
		//is set to false, whenever a node is of a type in nonConfSettings.
		boolean isConfidenceEdge = e.isConfidenceEdge();
		
		if (prettyEdge) {
			Color color = settings.getColor(new Integer(e.getType()));
			if (color == null) {
				color = nonConfSettings.getColor(new Integer(e.getType()));
				//isConfidenceEdge = false;
			}
			if (color == null)
				color = basicEdgeColor;
				
			g.setColor(color);
			PaintTools.paintPath(g, x1, y1, x2, y2, e.getOrientation(),
					BasicGraphPanel.offset, false, labelEdge && isConfidenceEdge, e.getConf(),
					false);
		} else {
			g.setColor(basicEdgeColor);
			PaintTools.paintPath(g, x1, y1, x2, y2, e.getOrientation(),
					BasicGraphPanel.offset, false, labelEdge && isConfidenceEdge, e.getConf(),
					false);
		}

		if (e.isHighlightedEdge()) {
			Composite orginalComp = g.getComposite();
			Stroke originalStroke = g.getStroke();

			g.setColor(new Color(223, 255, 0));
			AlphaComposite ac = AlphaComposite.getInstance(
					AlphaComposite.SRC_OVER, 0.5f);
			g.setComposite(ac);
			g.setStroke(new BasicStroke(2.0f));
			if (prettyEdge)
				PaintTools.paintPath(g, x1, y1, x2, y2, e.getOrientation(),
						BasicGraphPanel.offset, false, true && isConfidenceEdge, e.getConf(), true);
			else
				PaintTools.paintPath(g, x1, y1, x2, y2, e.getOrientation(),
						BasicGraphPanel.offset, false, true && isConfidenceEdge, e.getConf(), true);

			g.setComposite(orginalComp);
			g.setStroke(originalStroke);
		}

	}

	public void paintNode(Graphics2D g, Node n) {
		Color c = n.getColor();

		// EdgeMap eMap = new EdgeMap(graph);
		// eMap.createCompleteEdgeMatrix();
		// HashMap map = eMap.getCompleteEdgeMatrix();
		// int numOfConnections = ((ArrayList)map.get(n.getLabel())).size();

		int nodeSize = 15;
		if (prettyNode)
			nodeSize = Math.min(12 + n.getNodeSize() * 2, 30);

		int x = (int) n.getX() - (int) (nodeSize / 2.);
		int y = (int) n.getY() - (int) (nodeSize / 2.);

		int shapeID = n.getShape();
		if (uniformNodes && !n.isCollapseNode()) {
			shapeID = basicNodeShape;
			c = basicNodeColor;
		}
		
		Shape shape = medusa.display.PaintTools.getShape(shapeID, x, y,
				nodeSize);
		g.setPaint(c);
		g.fill(shape);
		g.setPaint(Color.black);

		if (n.isFixed()) {
			g.setPaint(Color.yellow);
		}

		if (n.isSearchHit()) {
			Composite orginal = g.getComposite();
			g.setColor(new Color(223, 255, 0));
			AlphaComposite ac = AlphaComposite.getInstance(
					AlphaComposite.SRC_OVER, 0.5f);
			g.setComposite(ac);
			int r = (nodeSize + 40) / 2;
			g.fillOval((int) n.getX() - r, (int) n.getY() - r, r * 2, r * 2);
			g.setComposite(orginal);
		}

		g.draw(shape);
		g.setPaint(fontColor);
		g.setFont(nodeFont);
		if (labelNode) {
			String label = n.getLabel();
			if (n.isCollapseNode())
				label = n.getDisplayLabel();
			g.drawString(label, x - 2, y - 2);
		}

	}

}
