/**
 * NormalPaintStyle.java
 */
package jsquid.display.drawing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;

import medusa.display.BasicGraphPanel;
import medusa.display.PaintTools;
import medusa.graph.Edge;
import medusa.graph.Node;

/**
 * @author sanjit and martin 
 * NormalPaintStyle - JSquidStyle
 */
public class NormalPaintStyle extends PaintStyle {

	/*
	 * (non-Javadoc)
	 * 
	 * @see jsquid.display.PaintMethods#paintEdge(java.awt.Graphics2D,
	 *      medusa.graph.Edge)
	 */
	public void paintEdge(Graphics2D g2d, Edge e) {
		// get the values
		Node from = graph.getNode(e.getFromName());
		Node to = graph.getNode(e.n2);
		int x1 = (int) from.getX();
		int y1 = (int) from.getY();
		int x2 = (int) to.getX();
		int y2 = (int) to.getY();

		// draw the proper stroke
		float confidence = e.getConf();
		Stroke stroke = new BasicStroke(1.0f);

		if (showConfidence) {
			// if (confidence >= 0.8)
			// stroke = new BasicStroke(5.0f);
			// else if (confidence >= 0.6)
			// stroke = new BasicStroke(4.5f);
			// else if (confidence >= 0.4)
			// stroke = new BasicStroke(1.0f);
			// else if (confidence >= 0.2) {
			// float dash[] = { 9.0f, 3.0f };
			// stroke = new BasicStroke(1.0f, BasicStroke.CAP_BUTT,
			// BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f);
			// } else {
			// float dash[] = { 3.0f, 9.0f };
			// stroke = new BasicStroke(1.0f, BasicStroke.CAP_BUTT,
			// BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f);
			// }

			stroke = new BasicStroke(5.0f * Math.min(confidence, 1.0f));
		}

		g2d.setStroke(stroke);

		//indicates whether the confidence of an edge is a real one
		//and should be displayed or is just for determining the line
		//thickness and therfore should not be displayed. this value
		//is set to false, whenever a node is of a type in nonConfSettings.
		boolean isConfidenceEdge = e.isConfidenceEdge();
		
		if (prettyEdge) {
			Color color = settings.getColor(new Integer(e.getType()));
			if (color == null) {
				color = nonConfSettings.getColor(new Integer(e.getType()));
				//isConfidenceEdge = false;
			}
			if (color == null)
				color = basicEdgeColor;
				
			g2d.setColor(color);
			PaintTools.paintPath(g2d, x1, y1, x2, y2, e.getOrientation(),
					BasicGraphPanel.offset, false, labelEdge && isConfidenceEdge, e.getConf(),
					false);
		} else {
			g2d.setColor(basicEdgeColor);
			PaintTools.paintPath(g2d, x1, y1, x2, y2, e.getOrientation(),
					BasicGraphPanel.offset, false, labelEdge && isConfidenceEdge, e.getConf(),
					false);
		}

		if (e.isHighlightedEdge()) {
			Composite orginal = g2d.getComposite();
			g2d.setColor(new Color(223, 255, 0));
			AlphaComposite ac = AlphaComposite.getInstance(
					AlphaComposite.SRC_OVER, 0.5f);
			g2d.setComposite(ac);
			g2d.setStroke(new BasicStroke(5.0f));
			if (prettyEdge)
				PaintTools.paintPath(g2d, x1, y1, x2, y2, e.getOrientation(),
						BasicGraphPanel.offset, false, true && isConfidenceEdge, e.getConf(), true);
			else
				PaintTools.paintPath(g2d, x1, y1, x2, y2, e.getOrientation(),
						BasicGraphPanel.offset, false, true && isConfidenceEdge, e.getConf(), true);
			g2d.setComposite(orginal);
		}

		g2d.setStroke(new BasicStroke(2.0F));

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jsquid.display.PaintMethods#paintNode(java.awt.Graphics2D,
	 *      medusa.graph.Node)
	 */
	public void paintNode(Graphics2D g, Node n) {
		Color c = n.getColor();

		// EdgeMap eMap = new EdgeMap(graph);
		// eMap.createCompleteEdgeMatrix();
		// HashMap map = eMap.getCompleteEdgeMatrix();
		// int numOfConnections = 0;
		// if (map.get(n.getLabel()) != null)
		// numOfConnections = ((ArrayList)map.get(n.getLabel())).size();
		//		
		int nodeSize = 15;
		if (prettyNode)
			nodeSize = Math.min(12 + n.getNodeSize() * 2, 30);

		int x = (int) n.getX() - (int) (nodeSize / 2.);
		int y = (int) n.getY() - (int) (nodeSize / 2.);
		int shapeID = n.getShape();
		if (uniformNodes && !n.isCollapseNode()) {
			shapeID = basicNodeShape;
			c = basicNodeColor;
		}

		Shape shape = PaintTools.getShape(shapeID, x, y, nodeSize);

		g.setPaint(c);
		g.fill(shape);
		if (n.isFixed()) { //Selected node
			g.setPaint(Color.orange);
			g.draw(shape);
		}
		else{ //border also for non selected node but thinner
			Stroke stroke = g.getStroke();
			g.setStroke(new BasicStroke(1.0F));
			g.setPaint(Color.black);
			g.draw(shape);
			g.setStroke(stroke);
		}
		if (n.isSearchHit()) {
			Composite orginal = g.getComposite();
			g.setColor(new Color(223, 255, 0));
			AlphaComposite ac = AlphaComposite.getInstance(
					AlphaComposite.SRC_OVER, 0.5f);
			g.setComposite(ac);
			int r = (nodeSize + 40) / 2;
			g.fillOval((int) n.getX() - r, (int) n.getY() - r, r * 2, r * 2);
			g.setComposite(orginal);
		}

		g.setPaint(Color.black);
		if (labelNode) {
			String label = n.getLabel();
			if (n.isCollapseNode())
				label = n.getDisplayLabel();

			Font originalFont = g.getFont();
			g.setFont(new Font("SansSerif", Font.BOLD, 12));
			g.setColor(Color.black);
			g.drawString(label, x - 2, y - 2);

			g.setFont(originalFont);
		}

	}

}
