package jsquid.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

import javax.swing.JPanel;

import medusa.display.PaintTools;
import medusa.graph.Node;

/**
 * 
 * @author martin
 *
 *creates a panel with a distinct shape (node shape) drawn within it
 */
public class ShapePanel extends JPanel{

	private int shapeID = 0;
	private Node node = null;
	
	public ShapePanel(Node node, int shape) {
		this.node = node;
		this.shapeID = shape;
		
		setMinimumSize(new Dimension(50,30));
		setPreferredSize(new Dimension(50,30));
		setMaximumSize(new Dimension(50,30));
	}
	
	//paints the shape
	public void paintComponent(Graphics g) {
		Shape s = PaintTools.getShape(shapeID, 10, 5, 20);
		Graphics2D g2d = (Graphics2D)g;
		
		if (node != null) {
			g2d.setPaint(node.getColor());
			g2d.fill(s);
			
			g2d.setPaint(Color.black);
			g2d.draw(s);
		}
	}

}
