package jsquid.display;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.WindowConstants;

import medusa.display.PaintTools;
import medusa.graph.Node;

/***
 * 
 * @author martin
 * this dialog for changing the shape of nodes. All available shapes are displayed and
 * the shape of interest can be selected with the corresponding radio button and set by clicking
 * the OK button. 
 *
 */
public class ShapeDialog extends JDialog implements ActionListener{

	//the affected node
	private Node node = null;
	//the list of selected nodes - it is possible to change several nodes at once
	private ArrayList fixedNodes = null;
	//every shape has a corresponding radio button
	private ArrayList rButtonList = new ArrayList();
	private JButton okButton = null;
	private JButton cancelButton = null;
	
	private int result = 0;
	
	public ShapeDialog(Node node, ArrayList fixedNodes) {
		this.node = node;
		this.fixedNodes = fixedNodes;
		
		//approximate calculation of the dialog's height
		//NOTE: SHAPE_COUNT represents the number of shapes available. It does not grow
		//dynamcally, when new shapes are added - if one adds new shapes, they have to increase this value too
		int dialogHeight = (int)Math.ceil((double)PaintTools.SHAPE_COUNT/2)*50 + 50;
		setSize(new Dimension(200, dialogHeight));
		
		setModal(true);
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		setVisible(false);
		setTitle("Choose node shape");
		
		JPanel shapePanel = populateShapePanel();
		shapePanel.setBorder(BorderFactory.createTitledBorder("Preview"));
		
		JPanel buttonPanel = new JPanel(new FlowLayout());
		okButton = new JButton("OK");
		cancelButton = new JButton("Cancel");
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		
		okButton.addActionListener(this);
		cancelButton.addActionListener(this);
		
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		panel.add(shapePanel);
		panel.add(buttonPanel);
		
		add(panel);
	}
	
	/**
	 * 
	 * @return the panel with shapes
	 * 
	 * creates and returns the panel which contains shapes and corresponding radio button
	 */
	private JPanel populateShapePanel() {
		JPanel panel = new JPanel(new GridLayout((int)Math.ceil((double)PaintTools.SHAPE_COUNT/2) ,2));
		
		int shapeCount = PaintTools.SHAPE_COUNT;
		for (int i = 0; i < shapeCount; ++i) {
			ShapePanel shapePanel = new ShapePanel(node, i);
			
			//this panel contains a shape - radio button - pair
			JPanel subPanel = new JPanel(new FlowLayout()); 
			JRadioButton rButton = new JRadioButton();
			if (node.getShape()==i) {
				rButton.setSelected(true);
				result = i;
			}
			rButton.addActionListener(this);
		
			rButtonList.add(rButton);
			
			subPanel.add(rButton);
			subPanel.add(shapePanel);
			panel.add(subPanel);
		}
		return panel;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == okButton) {
			node.setShape(result);
			
			//sets the new shape for all selected nodes, if the node which has been right clicked on
			//is amongst the selected ones
			if (fixedNodes.size() > 0 && fixedNodes.contains(node)) {
				for (int i = 0; i < fixedNodes.size(); ++i) 
					((Node)(fixedNodes.get(i))).setShape(result);
			}
			
			this.dispose();
		}
		else if (e.getSource() == cancelButton) {
			this.dispose();
		}
		else {
			//radio button functionality - only one is selected at the time
			JRadioButton sender = (JRadioButton) e.getSource();
			for (int i = 0; i < rButtonList.size(); ++i) {
				JRadioButton rButton = (JRadioButton)rButtonList.get(i);
				if (sender==rButton) {
					rButton.setSelected(true);
					result = i;
				}
				else {
					rButton.setSelected(false);
				}
			}	
		}
	}

}
