package jsquid.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;

import javax.swing.JPanel;

import jsquid.xml.LegendItem;

import medusa.display.PaintTools;

public class LegendPanel extends JPanel{

	private ArrayList legendItems;
	private int yCoord = 0;
	
	public LegendPanel(ArrayList legendItems) {
		this.legendItems = legendItems;
		setPreferredSize(new Dimension(350, (legendItems.size()+1)*30));
	}
	
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		for (int i = 0; i < legendItems.size(); ++i) {
			int yCoord = 30*i + 5;
			LegendItem item = (LegendItem) legendItems.get(i);
			Shape s = PaintTools.getShape(item.getShape(), 10, yCoord, 20);
			Graphics2D g2d = (Graphics2D)g;
		
			g2d.setPaint(item.getColor());
			g2d.fill(s);
			
			g2d.setPaint(Color.black);
			g2d.draw(s);
			
			g2d.drawString(item.getName(), 40, yCoord + 15);
		}
	}
}
