/**
 * EdgePanel.java
 *
 */
package jsquid.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.SoftBevelBorder;

/**
 * @author sanjit 
 * A Panel for one checkbox which is part of a EdgeMultiPanel
 */
public class EdgePanel extends JPanel implements ItemListener {

	private Color labelColor;

	private static final String mname = "handleEdgeEvent"; //Name of event(function)

	private String text;	//displayed text

	private String fullText;	//original text

	private int labelWidth = 40;

	private int labelHeight = 40;

	private int number = 0;	//number of box

	// private int showNumber = 0;

	private Object parent = null;	//ref to parent

	private JLabel edgeColorLabel;

	private JCheckBox edgeNameCheckBox;

	public EdgePanel(Color labelColor, String text, int labelWidth,
			int labelHeight, int number, int showNumber, Object parent) {
		this.parent = parent;
		this.labelColor = labelColor;
		this.text = text;
		this.fullText = text;
		this.labelWidth = labelWidth;
		this.labelHeight = labelHeight;
		// this.showNumber = showNumber;
		this.number = number;

		initComponents();
	}

	/**
	 * @return fullText
	 */
	public String getText() {
		return this.fullText;
	}

	/**
	 * State of checkbox changed
	 * Invoke method of parent with reflection 
	 */
	public void itemStateChanged(ItemEvent e) {
		try {
			Class c = parent.getClass();
			Class[] types = new Class[] { int.class, boolean.class };
			Method method = c.getMethod(mname, types);
			method.invoke(parent, new Object[] { new Integer(getNumber()),
					new Boolean(edgeNameCheckBox.isSelected()) });
		} catch (NoSuchMethodException exp) {
			System.out
					.println("handleEdgeEvent failed; Parent has no handleEdgeEvent(int, boolean) method");
		} catch (Exception exp) {
			System.out.println("handleEdgeEvent failed; Unknown Error");
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 */
	private void initComponents() {
		// numberLabel = new JLabel();
		edgeColorLabel = new JLabel();
		edgeColorLabel.setBackground(labelColor);
		Dimension d = new Dimension(labelWidth, labelHeight);
		edgeColorLabel.setPreferredSize(d);
		edgeColorLabel.setOpaque(true);
		edgeNameCheckBox = new JCheckBox();

		setLayout(new FlowLayout(FlowLayout.LEFT, 5, 0));

		edgeColorLabel.setBorder(new SoftBevelBorder(BevelBorder.RAISED));
		add(edgeColorLabel);

		edgeNameCheckBox.setOpaque(false);
		edgeNameCheckBox.setSelected(true);
		edgeNameCheckBox.setToolTipText(text);
		if (text.length() > 20) {
			text = text.substring(0, 17) + "...";
		}
		edgeNameCheckBox.setText(text);
		edgeNameCheckBox.addItemListener(this);
		add(edgeNameCheckBox);

	}

	/**
	 * @return number
	 */
	public int getNumber() {
		return number;
	}

	/**
	 * set a Checkbox
	 * @param isChecked checkbox value(boolean)
	 */
	public void setCheckBox(boolean isChecked) {
		this.edgeNameCheckBox.setSelected(isChecked);
	}

}
