/**
 * EdgeMultiPanel.java
 *
 */
package jsquid.display;

import java.awt.Color;
import java.awt.GridLayout;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JPanel;

import medusa.MedusaSettings;

/**
 * @author sanjit and martin 
 * Panel for the checkboxes to turn on/off different
 * kind of edge types
 */
public class EdgeMultiPanel extends JPanel {
	private MedusaSettings settings;

	private Object parent; // ref to parent

	private static final String mname = "handleEdgeEvent"; //Name of event(function) 

	private final int baseSize = 20;

	private Set edgeSet; //Set of edge types

	public EdgeMultiPanel(Object parent, MedusaSettings settings, Set edgeSet) {
		this.settings = settings;
		this.parent = parent;
		this.edgeSet = edgeSet;
		this.setBorder(BorderFactory.createEtchedBorder());
		initComponents();
		initEdgePanels();
	}

	/**
	 * change edgePanel with new @param settings
	 */
	public void updateSettings(MedusaSettings settings) {
		removeAll();
		this.settings = settings;
		initEdgePanels();
	}

	/**
	 * initalize edge Panel
	 */
	private void initEdgePanels() {
		// int counter = 0;
		EdgePanel edgeBox;
		//Iterate over all edge types
		for (Iterator iterEdge = edgeSet.iterator(); iterEdge.hasNext();) {
			Integer i = (Integer) iterEdge.next();
			if (settings.getColor(i) != null) {
				int index = i.intValue(); // +colorStartIndex;
				//create one edgeBox
				edgeBox = new EdgePanel(settings.getColor(i), settings
						.getName(i), baseSize, baseSize, index, index, this);
				add(edgeBox);
			}
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 */
	private void initComponents() {

		setLayout(new GridLayout(0, 1));

		setBackground(new Color(238, 238, 238));

	}

	/**
	 * handles the Edge Event by calling the method of the parent
	 * @param number which edgebox should be changed
	 * @param selected boolean if selected or not
	 */
	public void handleEdgeEvent(int number, boolean selected) {
		try {
			//call the method of the parent with reflection
			Class c = parent.getClass();
			Class[] types = new Class[] { int.class, boolean.class };
			Method method = c.getMethod(mname, types);
			method.invoke(parent, new Object[] { new Integer(number),
					new Boolean(selected) });
		} catch (NoSuchMethodException exp) {
			System.out
					.println("handleEdgeEvent failed; Parent has no handleEdgeEvent(int, boolean) method");
		} catch (Exception exp) {
			System.out.println("handleEdgeEvent failed; Unknown Error");
		}
	}

	/**
	 * set the CheckBoxes to default values
	 * default values are specified in the XML file
	 */
	public void setCheckBoxes() {
		Object[] components = this.getComponents();
		Hashtable checkedTable = settings.getCheckedTable();
		Hashtable interactionTable = settings.getInteractionTable();
		for (int i = 0; i < components.length; ++i) {
			EdgePanel panel = (EdgePanel) components[i];
			String interactionName = panel.getText();

			for (Iterator itor = interactionTable.keySet().iterator(); itor
					.hasNext();) {
				Integer id = (Integer) itor.next();
				String name = (String) interactionTable.get(id);

				if (name.equals(interactionName))
					panel.setCheckBox(((Boolean) checkedTable.get(id))
							.booleanValue());

			}
		}
	}
}
