/**
 * SearchTreeNode.java
 */
package jsquid.algorithm.data;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * @author sanjit
 * SearchTreeNode consists of a HashMap of links and a ArrayList of matches
 */
public class SearchTreeNode {

	private HashMap links; //Links to other SearchTreeNodes
	private ArrayList matches;
	
	public SearchTreeNode(){
		links = new HashMap();
		matches = new ArrayList();
	}

	/**
	 * @return links
	 */
	public HashMap getLinks() {
		return links;
	}

	/**
	 * @param links set links
	 */
	public void setLinks(HashMap links) {
		this.links = links;
	}

	/**
	 * @return matches
	 */
	public ArrayList getMatches() {
		return matches;
	}

	/**
	 * @param matches set matches
	 */
	public void setMatches(ArrayList matches) {
		this.matches = matches;
	}
	
	/**
	 * adds a link. key character, value new searchtreenode
	 * @param c
	 */
	public void addLink(char c){
		Character cobj = new Character(c);
		if(links.get(cobj) == null)
			links.put(cobj, new SearchTreeNode());
	}
	
	/**
	 * adds a match
	 * @param name
	 */
	public void addMatch(String name){
		matches.add(name);
	}
	
	/**
	 * returns link for a certain character
	 * @param c
	 * @return SearchTreeNode. if not found null
	 */
	public SearchTreeNode getLink(char c){
		return (SearchTreeNode)links.get(new Character(c));
	}
	
}
