/**
 * PairNeighbour.java
 */
package jsquid.algorithm.data;

/**
 * @author sanjit
 * A Pair of nodeName and Confidence
 * Represents a edge.
 */
public class PairNeighbour implements Comparable {

	private String nodeName;

	private float confidence;
	
	public PairNeighbour(){
		nodeName = "";
		confidence = 0;
	}
	
	public PairNeighbour(String nodeName, float confidence){
		this.nodeName = nodeName;
		this.confidence = confidence;
	}

	/**
	 * @return nodename
	 */
	public String getNodeName() {
		return nodeName;
	}

	/**
	 * @param nodeName set nodeName
	 */
	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	/**
	 * @return confidence
	 */
	public float getConfidence() {
		return confidence;
	}

	/**
	 * @param confidence set confidence
	 */
	public void setConfidence(float confidence) {
		this.confidence = confidence;
	}

	/**
	 * compare a pairneighbour object to another
	 * comparision based on confidence
	 */
	public int compareTo(Object arg) {
		float anotherConfidence = ((PairNeighbour) arg).getConfidence();
		float compare = this.confidence - anotherConfidence;
		if(compare == 0) return 0;
		else if(compare < 0) return 1;
		else return -1;
	}
	
}
