/**
 * ConfidenceClusterSettings.java
 */
package jsquid.algorithm.data;

/**
 * @author sanjit
 * ClusterSettings for Confidence Grouping. connection Cutoff and confidence Cutoff
 */
public class ConfidenceClusterSettings {
	private float connectionCut =  0.50F;
	
	private float confidenceCut = 0.50F;

	/**
	 * @return the confidenceCut
	 */
	public float getConfidenceCut() {
		return confidenceCut;
	}

	/**
	 * @param confidenceCut the confidenceCut to set
	 */
	public void setConfidenceCut(float confidenceCut) {
		if(confidenceCut >= 0 && confidenceCut <= 1)
			this.confidenceCut = confidenceCut;
	}

	/**
	 * @return the connectionCut
	 */
	public float getConnectionCut() {
		return connectionCut;
	}

	/**
	 * @param connectionCut the connectionCut to set
	 */
	public void setConnectionCut(float connectionCut) {
		if(connectionCut >= 0 && connectionCut <= 1)
			this.connectionCut = connectionCut;
	}
}
