/**
 * SearchTree.java
 */
package jsquid.algorithm;

import java.util.ArrayList;
import java.util.Iterator;

import jsquid.algorithm.data.SearchTreeNode;

/**
 * @author sanjit
 * Creates a simple SearchTree to search 
 * Search starts from the beginning of the keyword (no suffixtree)
 * Principle: single-linked list
 */
public class SearchTree {
	
	private SearchTreeNode start;
	
	public SearchTree(){
		start = new SearchTreeNode();
	}

	/**
	 * gets start node
	 * @return
	 */
	public SearchTreeNode getStart() {
		return start;
	}
	
	/**
	 * creates index for a iterator of strings
	 * @param iter Iterator of a Collection of strings
	 */
	public void createIndex(Iterator iter){
		while(iter.hasNext()){
			SearchTreeNode node = start;
			String key = (String)iter.next();
			//start.addMatch(key);
			char[] keyLetters = key.toCharArray();
			for(int i = 0; i < keyLetters.length; ++i){
				char c = Character.toUpperCase(keyLetters[i]);
				node.addLink(c);
				node = node.getLink(c);
				node.addMatch(key);
			}
		}
	}

	/**
	 * search a query in the linked list
	 * @param query
	 * @return ArrayList of nodes. If no match null.
	 */
	public ArrayList search(String query) {
		char[] queryLetters = query.toCharArray();
		SearchTreeNode node = start;
		for(int i = 0; i < queryLetters.length; ++i){
			char c = Character.toUpperCase(queryLetters[i]);
			node = node.getLink(c);
			if(node == null) return null;
		}
		return node.getMatches();
	}
}
