/**
 * ConfidenceSwitch.java
 */
package jsquid.algorithm;

import medusa.graph.Graph;

/**
 * @author sanjit
 * Confidence Switcher. To switch between diffrent confidence grouping (e.g. confidence
 * clustering for types, confidence clustering for species).
 */
public class ConfidenceSwitch {
	private Graph graph;
	
	private final static String confidenceType = "Confidence";

	public ConfidenceSwitch(Graph graph) {
		this.graph = graph;
	}

	/**
	 * switch Confidence Group to a diffrent IConfidenceCluster
	 * @param map
	 */
	public void switchConfidenceGroup(IConfidenceCluster map){
		graph.setGroup(confidenceType, map.getGroup());
	}

	/**
	 * @return the confidenceType
	 */
	public static final String getConfidenceType() {
		return confidenceType;
	}
}
