/**
 * JSquidApplet.java
 *
 */
package jsquid;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;

import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import sun.security.krb5.internal.crypto.Nonce;

import jsquid.algorithm.ConfidenceSwitch;
import jsquid.algorithm.IConfidenceCluster;
import jsquid.algorithm.MinimumCut;
import jsquid.display.ControlPanel;
import jsquid.algorithm.SearchTree;
import jsquid.algorithm.data.ConfidenceClusterSettings;
import jsquid.display.EdgeMultiPanel;
import jsquid.display.JRangeSlider;
import jsquid.display.JSearchPanel;
import jsquid.display.LegendPanel;
import jsquid.display.OverviewPanel;
import jsquid.display.drawing.factory.DrawingType;
import jsquid.display.event.SearchPanelEvent;
import jsquid.display.event.SearchPanelEventListener;
import jsquid.export.Utils;
import jsquid.export.picture.*;
import jsquid.export.xml.XGMMLConverter;
import jsquid.export.xml.XMLConverter;
import jsquid.export.filters.EPSFilter;
import jsquid.export.filters.GIFFilter;
import jsquid.export.filters.XGMMLFilter;
import jsquid.graph.JSquidGraph;
import jsquid.xml.InteractionClass;
import jsquid.xml.XMLDataLoader;
import jsquid.xml.XMLFileNotValidException;

import medusa.MedusaSettings;
import medusa.applet.MedusaLite;

/**
 * @author sanjit and martin 
 * Main Class Applet starting class. Initalize Panel,
 * Buttons, DataLoader and more.
 */

public class JSquidApplet extends MedusaLite implements ActionListener,
		ChangeListener, MouseWheelListener, SearchPanelEventListener {

	// Settings for the tabs
	private MedusaSettings typeSettings = null;

	private MedusaSettings speciesSettings = null;

	private MedusaSettings linkSettings = null;
	
	private MedusaSettings nonConfSettings = null;

	private JTabbedPane tabbedPane = null; // TabBar

	protected OverviewPanel overviewPanel = new OverviewPanel(); // small
																	// overview
																	// Panel

	public JPanel controlPanel = new ControlPanel(); // BottomPanel

	protected XMLDataLoader dl = null;

	// Confidence Slider with range from 0 to 10 = 0.0 to 1.0
	private JRangeSlider confidenceSlider = new JRangeSlider(
			new DefaultBoundedRangeModel(0, 10, 0, 10),
			JRangeSlider.HORIZONTAL, JRangeSlider.LEFTRIGHT_TOPBOTTOM);

	// Labels for confidenceSlider
	private JLabel lowConfLabel = new JLabel("0.0");

	private JLabel highConfLabel = new JLabel("1.0");

	private JSearchPanel searchField;

	private ConfidenceSwitch switcher; // To switch between different
										// confidence clustering(for the
										// different tabs)
	
	//URL for jSquid homepage
	public static final String jSquidHome = "http://jsquid.sbc.su.se";
	
	// Confidence cluster objects
	private IConfidenceCluster edgemapTypes;

	private IConfidenceCluster edgemapSpecies;

	private IConfidenceCluster edgemapSingleEdges;

	private IConfidenceCluster edgemapLinks;

	private JPanel scalerPanel = new JPanel(); // Scaling

	private JMenu groupMenu; // Menu for grouping

	// Checkbox Panels for Interaction Types
	EdgeMultiPanel edgeTypesPanel = null;

	EdgeMultiPanel edgeSpeciesPanel = null;

	EdgeMultiPanel edgeLinksPanel = null;
	
	JPanel edgeNonConfPanel = new JPanel(new GridLayout());;

	// Various MenuItems
	private JMenuItem layoutItem;

	private JMenuItem relaxLayoutItem;

	private JMenuItem simpleGraphItem;

	private JMenuItem exportPictureItem;

	private JMenuItem exportXMLItem;

	private JMenuItem confidenceGroupSettings;

	private JMenuItem connectionGroupSettings;

	private JMenuItem relaxSettings;

	private JMenuItem helpItem;
	
	private JMenuItem homeItem;
	
	private JMenuItem legendItem;

	private JCheckBoxMenuItem settingsEdgeConfidence;

	private JCheckBoxMenuItem settingsEdgeLabels;

	private JCheckBoxMenuItem settingsNodeInteraction;

	private JCheckBoxMenuItem settingsNodeLabels;
	
	private JCheckBoxMenuItem settingsUniformNodes;

	private JCheckBoxMenuItem settingsGroupLabels;
	
	JButton switchFromTabButton = new JButton("Detailed Links");

	private HashMap styleButtonMap = new HashMap(); // HashMap for different
													// Drawing Styles
	//holds the position of the mouse cursor on the last scroll event
	private Point lastPosOnMouseWheelScroll = null;
	
	// FileChooser
	final JFileChooser fcPicture = new JFileChooser();

	final JFileChooser fcXML = new JFileChooser();

	private double prevScale = 1.0; // Scalingfactor

	private int relaxIterations = 10; // Default Relax Iterations

	private ConfidenceClusterSettings confidenceSettings; // Settings for
															// ConfidenceClustering

	private JScrollPane helpPane; // Help Pane
	
	private JScrollPane legendPane;

	private static String helpFileLocation = "/jsquid/files/help.html"; //Location of help File

	/**
	 * Initalize Panel: Loads Data, Inits MedusaSettings, creates Panel
	 */
	public void initPanel() {
		System.out.println("Initializing JSquidPanel");

		String xml = getParameter("XML");
		xml = xml.replaceAll("&", "&amp;");
		InputStream xmlStream = new ByteArrayInputStream(xml.getBytes());

		URL schemaURL = this.getClass().getResource(
				"/jsquid/files/jsquidschema.xsd");
		String exceptionMsg = "";
		try {
			dl = new XMLDataLoader(schemaURL.toString(), xmlStream);
		} catch (XMLFileNotValidException ex) {
			stayAlive = false; // If XML File is invalid
			exceptionMsg = ex.getMessage();
		}

		if (stayAlive) {
			JSquidGraph g = (JSquidGraph) dl.loadParameters(); // Load
																// Parameters
			//g.sortEdgeList();
			// Load Settings
			typeSettings = new MedusaSettings(
					dl.getColorTable(InteractionClass.INTERACTIONCLASS_TYPES),
					dl.getInteractionTable(InteractionClass.INTERACTIONCLASS_TYPES),
					dl.getCheckedTable(InteractionClass.INTERACTIONCLASS_TYPES));
			speciesSettings = new MedusaSettings(
					dl.getColorTable(InteractionClass.INTERACTIONCLASS_SPECIES),
					dl.getInteractionTable(InteractionClass.INTERACTIONCLASS_SPECIES),
					dl.getCheckedTable(InteractionClass.INTERACTIONCLASS_SPECIES));
			linkSettings = new MedusaSettings(
					dl.getColorTable(InteractionClass.INTERACTIONCLASS_LINKS),
					dl.getInteractionTable(InteractionClass.INTERACTIONCLASS_LINKS),
					dl.getCheckedTable(InteractionClass.INTERACTIONCLASS_LINKS));
			nonConfSettings = new MedusaSettings(
					dl.getColorTable(InteractionClass.INTERACTIONCLASS_NONCONF),
					dl.getInteractionTable(InteractionClass.INTERACTIONCLASS_NONCONF),
					dl.getCheckedTable(InteractionClass.INTERACTIONCLASS_NONCONF));
			
			int colorTableSizeSum = typeSettings.getSizeColorTable()
					+ speciesSettings.getSizeColorTable()
					+ linkSettings.getSizeColorTable()
					+ nonConfSettings.getSizeColorTable();
			// Panel
			panel = new JSquidPanel(typeSettings, this, overviewPanel,
					colorTableSizeSum);
			setStyleSettings();
			g.findNonConfEdges(nonConfSettings);
			panel.setGraph(g);
			((JSquidPanel) panel).setNonConfSettings(nonConfSettings);
			panel.addMouseWheelListener(this);
			// OverviewPanel
			overviewPanel.setDrawingPanelRef(panel);

			((JSquidPanel) panel).updateShow();

			setJMenuBar(createMenuBar());
			if (dl.isDistributeOnInit())
				panel.energy();
			if (dl.isShowMedusaStyle()) {
				((JSquidPanel)panel).switchStyle(DrawingType.OLDTYPE);
				switchStyleButton(DrawingType.OLDTYPE);
			}
		}
		//if the XML file has been invalid
		else {
			JLabel xmlInvalidLabel = new JLabel();
			xmlInvalidLabel.setText("<html><h2>XML File Invalid!</h2></br><h3>" +
					"Error Message: " + exceptionMsg + "</h3></html>");
			this.add(xmlInvalidLabel, "Center");
		}
	}

	private void setStyleSettings() {
		panel.prettyNode = dl.isShowNodeSize();
		panel.labelEdge = dl.isShowEdgeLabels();
		panel.labelNode = dl.isShowNodeLabels();
		panel.showConfidence = dl.isShowEdgeConf();
		panel.labelGroup = dl.isShowGroupLabels();
		panel.uniformNodes = dl.isShowUniformNodes();
	}
	
	/**
	 * Creates the MenuBar of the Applet
	 * 
	 * @return created MenuBar
	 */
	private JMenuBar createMenuBar() {
		JMenuBar menuBar = new JMenuBar();
		JMenu fileMenu = new JMenu("Export");
		JMenu preferenceMenu = new JMenu("Preferences");
		JMenu groupingPrefMenu = new JMenu("Grouping");
		JMenu relaxPrefMenu = new JMenu("Relax");
		JMenu displayMenu = new JMenu("View");
		JMenu styleMenu = new JMenu("Style");
		JMenu settingsMenu = new JMenu("DisplaySettings");
		groupMenu = new JMenu("Group Nodes By");
		JMenu helpMenu = new JMenu("Help");
		JMenu aboutMenu = new JMenu("About");
		JLabel aboutLabel = new JLabel();

		exportPictureItem = new JMenuItem("Export As Picture");
		exportXMLItem = new JMenuItem("Export As XML");

		fileMenu.add(exportPictureItem);
		fileMenu.add(exportXMLItem);

		exportPictureItem.addActionListener(this);
		exportXMLItem.addActionListener(this);

		confidenceGroupSettings = new JMenuItem("Confidence cutoff");
		connectionGroupSettings = new JMenuItem("Connectivity cutoff");
		groupingPrefMenu.add(confidenceGroupSettings);
		groupingPrefMenu.add(connectionGroupSettings);
		preferenceMenu.add(groupingPrefMenu);

		confidenceGroupSettings.addActionListener(this);
		connectionGroupSettings.addActionListener(this);

		relaxSettings = new JMenuItem("Iterations");
		relaxPrefMenu.add(relaxSettings);
		preferenceMenu.add(relaxPrefMenu);

		relaxSettings.addActionListener(this);

		// settingsEdgeColors = new JCheckBoxMenuItem("Show edge color", false);
		settingsEdgeConfidence = new JCheckBoxMenuItem("Edge confidences",
				panel.showConfidence);
		settingsEdgeLabels = new JCheckBoxMenuItem("Edge labels", panel.labelEdge);
		settingsNodeInteraction = new JCheckBoxMenuItem("Node sizes", panel.prettyNode);
		settingsNodeLabels = new JCheckBoxMenuItem("Node labels", panel.labelNode);
		settingsUniformNodes = new JCheckBoxMenuItem("Uniform nodes", panel.uniformNodes);
		settingsGroupLabels = new JCheckBoxMenuItem("Group labels", panel.labelGroup);

		// settingsMenu.add(settingsEdgeColors);
		settingsMenu.add(settingsEdgeConfidence);
		settingsMenu.add(settingsEdgeLabels);
		settingsMenu.addSeparator();
		settingsMenu.add(settingsNodeInteraction);
		settingsMenu.add(settingsNodeLabels);
		settingsMenu.add(settingsUniformNodes);
		settingsMenu.addSeparator();
		settingsMenu.add(settingsGroupLabels);
		// settingsMenu.setMnemonic('D');

		// settingsEdgeColors.addActionListener(this);
		settingsEdgeConfidence.addActionListener(this);
		settingsEdgeLabels.addActionListener(this);
		settingsNodeInteraction.addActionListener(this);
		settingsNodeLabels.addActionListener(this);
		settingsUniformNodes.addActionListener(this);
		settingsGroupLabels.addActionListener(this);

		addGroups(); //Add Grouping
		addStyles(styleMenu); //Add Styles

		layoutItem = new JMenuItem("Redistribute");
		layoutItem.addActionListener(this);

		relaxLayoutItem = new JMenuItem("Relax");
		relaxLayoutItem.addActionListener(this);

		simpleGraphItem = new JMenuItem("Detailed Links");
		simpleGraphItem.setText(panel.prettyEdge ? "Summary Links"
				: "Detailed Links");
		simpleGraphItem.addActionListener(this);

		aboutLabel
				.setText("<html>jSquid Applet V1.05<br>( c ) Martin Klammer & Sanjit Roopra under GPLv3<br>"
						+ "SBC, Stockholm, Sep2007-Jan2008 </html>");
		// aboutMenu.setMnemonic('A');
		aboutMenu.add(aboutLabel);

		helpItem = new JMenuItem("Help");
		helpItem.addActionListener(this);
		helpMenu.add(helpItem);
		legendItem = new JMenuItem("Legend");
		legendItem.addActionListener(this);
		helpMenu.add(legendItem);
		homeItem = new JMenuItem("jSquid Home");
		homeItem.addActionListener(this);
		helpMenu.add(homeItem);
		helpMenu.add(aboutMenu);
		displayMenu.add(layoutItem);
		displayMenu.add(relaxLayoutItem);
		displayMenu.add(simpleGraphItem);
		displayMenu.add(styleMenu);
		displayMenu.add(settingsMenu);
		menuBar.add(displayMenu);
		menuBar.add(groupMenu);
		menuBar.add(preferenceMenu);
		menuBar.add(fileMenu);
		menuBar.add(helpMenu);

		return menuBar;
	}

	/**
	 * Creates Style Menu
	 * 
	 * @param styleMenu
	 *            JMenu where style Menu should be created
	 */
	private void addStyles(JMenu styleMenu) {
		ButtonGroup group = new ButtonGroup();
		// Iterate over all DrawingTypes and create RadioButtons
		Class c = DrawingType.class;
		Field[] fields = c.getFields();
		for (int i = 0; i < fields.length; i++) {
			JRadioButtonMenuItem rItem;
			try {
				String style = (String) fields[i].get(DrawingType.class);
				rItem = new JRadioButtonMenuItem(style);
				rItem.addActionListener(this);
				if (i == 0)
					rItem.setSelected(true);
				group.add(rItem);
				styleButtonMap.put(style, rItem); //connect style with radioButton
				styleMenu.add(rItem);
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * For Grouping Menu add Groups Hierachy Format
	 */
	private void addGroups() {
		String[] groups = dl.getNodeGroupArray(); // Get Groups
		Arrays.sort(groups);
		JMenu hierarchyMenu = null; // Top Level Menu
		JMenu nonWordMenu = null; // Top Level Menu for non Words (Numbers, special character)
		String firstChar = " ";
		JMenu pathwayGroupMenu = null;

		// Create Menu for Confidence Grouping to be at the top
		JMenuItem confGroupItem = new JMenuItem(ConfidenceSwitch
				.getConfidenceType());
		groupMenu.add(confGroupItem);
		confGroupItem.addActionListener(this);
		// If available create Menu for Location grouping to be at the top
		int pos = Arrays.binarySearch(groups, XMLDataLoader.LOCATION_GRP_CONST,
				String.CASE_INSENSITIVE_ORDER);
		if (pos >= 0) {
			JMenuItem locationGroupItem = new JMenuItem(groups[pos]);
			groupMenu.add(locationGroupItem);
			locationGroupItem.addActionListener(this);
		}
		// Create other groups
		for (int i = 0; i < groups.length; ++i) {

			if ((i != pos) && !groups[i].equalsIgnoreCase(ConfidenceSwitch
					.getConfidenceType())) { // Don't create group for Location and Confidence again
				if (pathwayGroupMenu == null)
					pathwayGroupMenu = new JMenu("Pathways");
				JMenuItem groupItem = new JMenuItem(groups[i]);
				groups[i] = groups[i].toUpperCase();
				// If not a word
				if (groups[i].charAt(0) < 'A' || groups[i].charAt(0) > 'Z') {
					if (nonWordMenu == null)
						nonWordMenu = new JMenu("Others");
					nonWordMenu.add(groupItem);
				} else { // A word
					if (firstChar.charAt(0) != groups[i].charAt(0)) {
						firstChar = "" + groups[i].charAt(0);
						hierarchyMenu = new JMenu(firstChar);
					}
					hierarchyMenu.add(groupItem);
					pathwayGroupMenu.add(hierarchyMenu);
				}
				groupItem.addActionListener(this);
			}
		}
		if (nonWordMenu != null && pathwayGroupMenu != null)
			pathwayGroupMenu.add(nonWordMenu);
		if (pathwayGroupMenu != null)
		groupMenu.add(pathwayGroupMenu);
	}

	/**
	 * inits Applet Loads Panel, inits ConfidenceClustering, creates SearchTree,
	 * inits confidenceSlider, searchPanel, overviewPanel
	 */
	public void init() {
		super.init();
		if (stayAlive) {
			FlowLayout layout = new FlowLayout(FlowLayout.LEFT);
			controlPanel.setLayout(layout);
			// init confidenceClusterSettings
			confidenceSettings = new ConfidenceClusterSettings();
			confidenceSettings.setConnectionCut(dl.getConnectionCutoff());
			confidenceSettings.setConfidenceCut(dl.getConfidenceCutoff());

			createConfidenceClustering(); // Creates the clustering

			// Creater Switcher for Confidence Clustering (Switching tabs ->
			// different edges)
			switcher = new ConfidenceSwitch(panel.getGraph());
			switcher.switchConfidenceGroup(edgemapSingleEdges);

			// Creates the searchTree for node Names
			SearchTree tree = new SearchTree();
			tree.createIndex(panel.getGraph().getNodeHM().keySet().iterator());
			searchField = new JSearchPanel(tree);

			Container content = getContentPane();
			createTabbedPane(); // Tab Panel

			// Listener for confidenceSlider
			confidenceSlider.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					JRangeSlider source = (JRangeSlider) e.getSource();
					DecimalFormat df = new DecimalFormat("0.0");
					lowConfLabel.setText(df.format(((double) source
							.getLowValue()) / 10));
//					if (source.getHighValue() == 10)
//						highConfLabel.setText("1.0+");
//					else
					highConfLabel.setText(df.format(((double) source
							.getHighValue()) / 10));
					((JSquidPanel) panel).setEdgeRange(source.getLowValue(),
							source.getHighValue());
					if (getPanel().isShowGroupBorders()
							&& ((JSquidPanel) panel).getGroupType().length() != 0) {
						// System.out.println("aaa");
						getPanel().paintImmediately(0, 0,
								getPanel().getWidth(), getPanel().getHeight());
						// getPanel().forceRepaint();
						((JSquidPanel) panel).groupBy(((JSquidPanel) panel)
								.getGroupType());
						// getPanel().repaint();
					}
					scalerSlider.setValue(100);
				}

			});
			switchFromTabButton.addActionListener(this);
			
			// ConfidenceSlider Panel
			JPanel rangePanel = new JPanel();
			//rangePanel.setPreferredSize(new Dimension(190, 52));
			rangePanel.add(lowConfLabel);
			rangePanel.add(confidenceSlider);
			rangePanel.add(highConfLabel);
			rangePanel.setBorder(BorderFactory
					.createTitledBorder("Confidence range"));
			controlPanel.add(rangePanel);

			// SearchFiel Panel
			searchField.addSearchPanelEvent(this);
			JPanel searchPanel = new JPanel();
			searchPanel.add(searchField);
			searchPanel.setBorder(BorderFactory
					.createTitledBorder("Search nodes"));
			controlPanel.add(searchPanel);
			
			//scaling slider
			populateScalerPanel();
			controlPanel.add(scalerPanel);

			content.add("South", controlPanel);
			
			createNonConfidencePanel();
			JPanel combiPanel = new JPanel();

			// OverviewPanel
			overviewPanel.setGraph(panel.getGraph());
			// use setPreferredSize to set the size of this panel
			overviewPanel.setPreferredSize(new Dimension(150, 125));
			overviewPanel.setMaximumSize(new Dimension(150, 125));
			overviewPanel.setMinimumSize(new Dimension(150, 125));

			combiPanel.setLayout(new BoxLayout(combiPanel, BoxLayout.Y_AXIS));
			combiPanel.add(tabbedPane);
			//combiPanel.add(scalerPanel);
			combiPanel.add(edgeNonConfPanel);
			combiPanel.add(overviewPanel);

			overviewPanel.repaint();

			initHelpString(); // Load Help
			setFileChooserFilter(); // Init FileChoosers
			
			LegendPanel legendPanel = new LegendPanel(dl.getLegend());
			legendPane = new JScrollPane(legendPanel);
			legendPane.setPreferredSize(new Dimension(300, 225));

			content.add("East", combiPanel);

			Runtime rt = Runtime.getRuntime();
			rt.gc();

			setVisible(true);
			performTooltipInvokeAction(); // To gain tooltip for the applet
		}
	}

	/**
	 * Initalize HelpString from an HTML File
	 */
	private void initHelpString() {
		URL helpURL = this.getClass().getResource(helpFileLocation);
		JTextPane area = new JTextPane();
		area.setEditable(false);
		try {
			area.setPage(helpURL);
		} catch (IOException e1) {
			e1.printStackTrace();
		}

		helpPane = new JScrollPane(area);
		helpPane.setPreferredSize(new Dimension(500, 600));

	}

	/**
	 * Created the Tab Panel currently three tabs: Types, Species and Links
	 */
	private void createTabbedPane() {
		if (tabbedPane == null) { // Initalize tab
			tabbedPane = new JTabbedPane();
			edgeTypesPanel = new EdgeMultiPanel(this, typeSettings, dl
					.getEdgetypes());
			edgeSpeciesPanel = new EdgeMultiPanel(this, speciesSettings, dl
					.getEdgetypes());
			edgeLinksPanel = new EdgeMultiPanel(this, linkSettings, dl
					.getEdgetypes());
		}
		tabbedPane.setFont(new Font("Arial", Font.PLAIN, 9));
		tabbedPane.removeAll();
		tabbedPane.removeChangeListener(this);
		// Show Tab if extended Graph is shown
		if (panel.prettyEdge) {
			edgeTypesPanel.setCheckBoxes();

			tabbedPane.setEnabled(true);
			tabbedPane.addTab("Types", edgeTypesPanel);
			tabbedPane.addTab("Species", edgeSpeciesPanel);
			tabbedPane.addTab("Predictions", edgeLinksPanel);
			//tabbedPane.setEnabledAt(2, false);
			tabbedPane.setToolTipTextAt(0,
					"<html><b>Evidence by Type</b></html>");
			tabbedPane.setToolTipTextAt(1,
					"<html><b>Evidence by Species</b></html>");
			tabbedPane.setToolTipTextAt(2,
					"<html><b>Predicted Links</b></html>");

			tabbedPane.addChangeListener(this);
			((JSquidPanel) panel).setSettings(typeSettings);
			((JSquidPanel) panel).updateShow();
			EdgeMultiPanel emPanel = (EdgeMultiPanel) tabbedPane
					.getComponent(0);
			emPanel.setCheckBoxes();
			switcher.switchConfidenceGroup(edgemapTypes);
		} else { // Disable tab if simple Graph is shown
			tabbedPane.setEnabled(false);
			JPanel tabPanel = new JPanel();
			JPanel labelPanel= new JPanel();
			JPanel buttonPanel = new JPanel();
			tabPanel.setLayout(new BoxLayout(tabPanel, BoxLayout.Y_AXIS));
			JLabel info = new JLabel(
					"<html><br><br><br><br><br>&nbsp;&nbsp;Switch to Detailed Links&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
							+ "<br>&nbsp;&nbsp;in the View menu<br>&nbsp;&nbsp;or press the button below<br>&nbsp;&nbsp;to use these tabs.<br><br></html>");
			info.setForeground(Color.gray);
			labelPanel.add(info);
			buttonPanel.add(switchFromTabButton);
			tabPanel.add(labelPanel);
			tabPanel.add(buttonPanel);
			tabbedPane.addTab("Types", tabPanel);
			tabbedPane.addTab("Species", null);
			tabbedPane.addTab("Predictions", null);
			switcher.switchConfidenceGroup(edgemapSingleEdges);
		}
	}

	/**
	 * Creates the Confidence Clustering for all Tabs and the simple Graph
	 */
	private void createConfidenceClustering() {
		edgemapSpecies = new MinimumCut(panel.getGraph(), confidenceSettings);
		edgemapSpecies.createEdgeMatrix(speciesSettings);
		edgemapSpecies.groupByConfidence();

		edgemapTypes = new MinimumCut(panel.getGraph(), confidenceSettings);
		edgemapTypes.createEdgeMatrix(typeSettings);
		edgemapTypes.groupByConfidence();

		edgemapLinks = new MinimumCut(panel.getGraph(), confidenceSettings);
		edgemapLinks.createEdgeMatrix(linkSettings);
		edgemapLinks.groupByConfidence();

		edgemapSingleEdges = new MinimumCut(panel.getGraph(),
				confidenceSettings);
		edgemapSingleEdges.createSingleEdgeMatrix();
		edgemapSingleEdges.groupByConfidence();
	}

	/**
	 * Initalize FileChooserFilters for Picture and XML
	 */
	private void setFileChooserFilter() {
		fcPicture.setAcceptAllFileFilterUsed(false);
		fcPicture.addChoosableFileFilter(new EPSFilter());
		fcPicture.addChoosableFileFilter(new GIFFilter());

		fcXML.setAcceptAllFileFilterUsed(false);
		fcXML.addChoosableFileFilter(new XGMMLFilter());
	}

	/**
	 * Action Handling for the Class
	 */
	public void actionPerformed(ActionEvent e) {
		Object es = e.getSource();
		if (es == layoutItem) { // Redistribute Fruchterman Reingold Layout
			scalerSlider.setValue(100);
			relax.setSelected(false);
			getPanel().energy();
		} else if (es == relaxLayoutItem) { // Relax Layout
			scalerSlider.setValue(100);
			panel.runRelax(relaxIterations);
			((JSquidPanel) panel).setShowGroupBorders(false);
		} else if (es == simpleGraphItem || es == switchFromTabButton) { // Switch simple/extended graph
			panel.prettyEdge = !panel.prettyEdge;
			simpleGraphItem.setText(panel.prettyEdge ? "Summary Links"
					: "Detailed Links");
			createTabbedPane();
			createNonConfidencePanel();
			((JSquidPanel) panel).initSubEdgesList();
			((JSquidPanel) panel).checkShowGroups();
			((JSquidPanel) panel).setShowGroupBorders(false);
			confidenceSlider.setLowValue(0);
			confidenceSlider.setHighValue(10);
			//repaint();
		} else if (es == exportPictureItem) { // export as Picture

			int returnVal = fcPicture.showSaveDialog(this);

			if (returnVal == JFileChooser.APPROVE_OPTION) {
				PictureExporter exporter = null;
				if (fcPicture.getFileFilter().getClass() == GIFFilter.class) {
					File file = Utils.checkExtension(fcPicture
							.getSelectedFile(), Utils.GIF);
					exporter = new ExportToGIF(file, (JSquidPanel) getPanel());
				} else {
					File file = Utils.checkExtension(fcPicture
							.getSelectedFile(), Utils.EPS);
					exporter = new ExportToEPS(file, (JSquidPanel) getPanel());
				}
				try {
					exporter.export();
				} catch (IOException e1) {
					JOptionPane.showMessageDialog(this, "Error saving file",
							"Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		} else if (es == exportXMLItem) { // export as XML
			int returnVal = fcXML.showSaveDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				XMLConverter converter = null;
				if (fcXML.getFileFilter().getClass() == XGMMLFilter.class) {
					converter = new XGMMLConverter(fcXML.getSelectedFile(),
							getPanel().getGraph(), ((JSquidPanel) getPanel())
									.getSettings(), getPanel().prettyEdge);
				}

				try {
					converter.convert();
				} catch (Exception e1) {
					JOptionPane.showMessageDialog(this, "Error saving file",
							"Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		} else if (es == confidenceGroupSettings) { // Settings for confidence
													// Grouping(confidence)
			float value = showConfidenceSettingsDialog(
					"Enter Confidence Cutoff Value", confidenceSettings
							.getConfidenceCut());
			if (value != confidenceSettings.getConfidenceCut()) {
				confidenceSettings.setConfidenceCut(value);
				refreshConfidenceCluster();
			}
		} else if (es == connectionGroupSettings) { // Settings for confidence
													// Grouping(connection)
			float value = showConfidenceSettingsDialog(
					"Enter Connection Cutoff Value", confidenceSettings
							.getConnectionCut());
			if (value != confidenceSettings.getConnectionCut()) {
				confidenceSettings.setConnectionCut(value);
				refreshConfidenceCluster();
			}
		} else if (es == relaxSettings) { // Iterations for Relax Layout
			String input = (String) JOptionPane.showInputDialog(this,
					"Enter Number of Relax Iterations", "Relax Settings",
					JOptionPane.QUESTION_MESSAGE, null, null, new Integer(
							relaxIterations));
			if (input != null) {
				try {
					int value = Integer.parseInt(input);
					if (value < 0 || value > 1000)
						throw new Exception();
					else
						relaxIterations = value;
				} catch (Exception ex) {
					JOptionPane.showMessageDialog(this,
							"Invalid value! Value must be between 0 - 1000",
							"Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		} else if (es == helpItem) { // Show help

			JOptionPane.showMessageDialog(this, helpPane, "Help",
					JOptionPane.INFORMATION_MESSAGE);
		} else if (es == legendItem) { // Show legend
			JOptionPane.showMessageDialog(this, legendPane, "Legend",
					JOptionPane.INFORMATION_MESSAGE);
		}
		else if (es == homeItem) {
			try {
				getAppletContext().showDocument(new URL(jSquidHome),
				"_blank");
			} catch (MalformedURLException e1) {
				// do nothing
			}
		}else if (es.getClass() == JMenuItem.class) { // All other MenuItems
														// are for grouping
			JMenuItem item = (JMenuItem) es;
			scalerSlider.setValue(100);
			((JSquidPanel) panel).groupBy(item.getText());
			getPanel().repaint();
		} else if (es.getClass() == JRadioButtonMenuItem.class) { // All other
																	// RadioButtonItems
																	// are for
																	// style
			JRadioButtonMenuItem item = (JRadioButtonMenuItem) es;
			((JSquidPanel) panel).switchStyle(item.getText());
		} else if (es == settingsEdgeConfidence) // enable/disable Edge
													// Confidence
			panel.showConfidence = !panel.showConfidence;
		else if (es == settingsEdgeLabels) { // enable/disable Edge Labels
			panel.labelEdge = !panel.labelEdge;
		} else if (es == settingsNodeInteraction) // enable/disable Node Size
			panel.prettyNode = !panel.prettyNode;
		else if (es == settingsNodeLabels) // enable/disable Node Labels
			panel.labelNode = !panel.labelNode; //enable/disable uniform nodes
		else if (es == settingsUniformNodes)
			panel.uniformNodes = ! panel.uniformNodes;
		else if (es == settingsGroupLabels) // enable/disable Group Labels
			panel.labelGroup = !panel.labelGroup;

		overviewPanel.repaint();

	}

	/**
	 * switch the Style Button to
	 * 
	 * @param style
	 */
	public void switchStyleButton(String style) {
		if (styleButtonMap.containsKey(style)) {
			JRadioButtonMenuItem item = (JRadioButtonMenuItem) styleButtonMap
					.get(style);
			item.setSelected(true);
		}
	}

	/**
	 * Show the Dialog for Confidence Settings
	 * 
	 * @param message
	 *            The message which will be displayed
	 * @param initValue
	 *            The inital Value
	 * @return the new Value
	 */
	private float showConfidenceSettingsDialog(String message, float initValue) {
		float value = initValue;
		String input = (String) JOptionPane.showInputDialog(this, message,
				"GroupBy Confidence Settings", JOptionPane.QUESTION_MESSAGE,
				null, null, new Float(initValue));
		if (input != null) {
			try {
				value = Float.parseFloat(input);
				if (value < 0 || value > 1) {
					value = initValue;
					throw new Exception();
				}
			} catch (Exception e) {
				JOptionPane.showMessageDialog(this,
						"Invalid value! Value must be between 0.00 - 1.00",
						"Error", JOptionPane.ERROR_MESSAGE);
			}
		}
		return value;
	}

	/**
	 * Refresh the Confidence Clusters and sets the correct Confidence Group
	 */
	private void refreshConfidenceCluster() {

		// Refresh Cluster
		edgemapTypes.createEdgeMatrix(typeSettings);
		edgemapTypes.groupByConfidence();
		edgemapSpecies.createEdgeMatrix(speciesSettings);
		edgemapSpecies.groupByConfidence();
		edgemapLinks.createEdgeMatrix(linkSettings);
		edgemapLinks.groupByConfidence();
		edgemapSingleEdges.createSingleEdgeMatrix();
		edgemapSingleEdges.groupByConfidence();

		// set correct group which is currently displayed
		if (!getPanel().prettyEdge)
			switcher.switchConfidenceGroup(edgemapSingleEdges);
		else if (((JSquidPanel) getPanel()).getSettings() == typeSettings) {
			switcher.switchConfidenceGroup(edgemapTypes);
		} else if (((JSquidPanel) getPanel()).getSettings() == speciesSettings) {
			switcher.switchConfidenceGroup(edgemapSpecies);
		} else if (((JSquidPanel) getPanel()).getSettings() == linkSettings) {
			switcher.switchConfidenceGroup(edgemapLinks);
		}
	}

	/**
	 * Handles the event for the checkbox to turn on or off a edge types
	 * 
	 * @param number
	 *            which checkbox
	 * @param selected
	 *            on or off
	 */
	public void handleEdgeEvent(int number, boolean selected) {
		((JSquidPanel) panel).setShowEdges(number, selected);

		getPanel().paintImmediately(0, 0, getPanel().getWidth(),
				getPanel().getHeight());
		// getPanel().forceRepaint();
		if (getPanel().isShowGroupBorders())
			((JSquidPanel) panel).groupBy(((JSquidPanel) panel).getGroupType());

		panel.repaint();
	}

	/**
	 * state Changed Events for Class
	 */
	public void stateChanged(ChangeEvent e) {
		Object sender = e.getSource();
		if (e.getSource() instanceof JSlider) { // Event for Scaling
			JSlider slider = (JSlider) sender;

			if (!slider.getValueIsAdjusting()) {
				double scale = (slider.getValue() + 1) * 0.01;
				scale = Math.max(0.1, scale);
				((JSquidPanel) panel).rescaleNodes(scale / prevScale);

				overviewPanel.resizeOverviewRect(scale);
				overviewPanel.repaint();

				prevScale = scale;
			}
		} else if (sender instanceof JTabbedPane) { // Event for TabPane
			JTabbedPane pane = (JTabbedPane) sender;
			EdgeMultiPanel emPanel;

			int selectedTabIndex = pane.getSelectedIndex();
			if (selectedTabIndex == 0) { // types
				((JSquidPanel) panel).setSettings(typeSettings);
				((JSquidPanel) panel).updateShow();
				emPanel = (EdgeMultiPanel) pane.getComponent(0);
				emPanel.setCheckBoxes();
				//((EdgeMultiPanel)edgeNonConfPanel.getComponent(0)).setCheckBoxes();
				switcher.switchConfidenceGroup(edgemapTypes);
				((JSquidPanel) panel).checkShowGroups();
			} else if (selectedTabIndex == 1) { // species
				((JSquidPanel) panel).setSettings(speciesSettings);
				((JSquidPanel) panel).updateShow();
				emPanel = (EdgeMultiPanel) pane.getComponent(1);
				emPanel.setCheckBoxes();
				//((EdgeMultiPanel)edgeNonConfPanel.getComponent(0)).setCheckBoxes();
				switcher.switchConfidenceGroup(edgemapSpecies);
				((JSquidPanel) panel).checkShowGroups();
			} else if (selectedTabIndex == 2) { // predicted links
				((JSquidPanel) panel).setSettings(linkSettings);
				((JSquidPanel) panel).updateShow();
				emPanel = (EdgeMultiPanel) pane.getComponent(2);
				emPanel.setCheckBoxes();
				//((EdgeMultiPanel)edgeNonConfPanel.getComponent(0)).setCheckBoxes();
				switcher.switchConfidenceGroup(edgemapLinks);
				((JSquidPanel) panel).checkShowGroups();
			}

			panel.repaint();
		}

	}

	/**
	 * Creates the Scale Bar in a Panel
	 */
	private void populateScalerPanel() {
//		JLabel scalerLabel = new JLabel("Scale  ");
		scalerPanel.setLayout(new GridLayout());
		scalerPanel.setPreferredSize(new Dimension(300,53));
		scalerPanel.setOpaque(false);
		scalerPanel.setBackground(getBackground());
		scalerSlider.setMajorTickSpacing(100);
		scalerSlider.setMinorTickSpacing(10);
		//scalerSlider.setPaintTicks(true);
		scalerSlider.setPaintLabels(true);
		scalerSlider.setSnapToTicks(true);
//		scalerSlider.setAlignmentX(RIGHT_ALIGNMENT);
//		scalerLabel.setAlignmentX(RIGHT_ALIGNMENT);
//		scalerPanel.add(scalerLabel);
		scalerPanel.add(scalerSlider);
		scalerPanel.setBorder(BorderFactory.createTitledBorder("Scale"));
		scalerSlider.addChangeListener(this);
		scalerSlider.addMouseWheelListener(this);

	}
	
	private void createNonConfidencePanel() {
		TitledBorder border = BorderFactory.createTitledBorder("Other links");
		Font font = new Font("Arial", Font.PLAIN, 10);
		border.setTitleFont(font);
		if (panel.prettyEdge) {
			edgeNonConfPanel.removeAll();
			if (nonConfSettings.getCheckedTable().size() > 0) {
				EdgeMultiPanel multiPanel = new EdgeMultiPanel(this, nonConfSettings, dl
						.getEdgetypes());
				multiPanel.setCheckBoxes();
				multiPanel.setBorder(BorderFactory.createEmptyBorder());
				edgeNonConfPanel.add(multiPanel);
			} else {
				JLabel info = new JLabel("<html>&nbsp;&nbsp;No types available.</html>");
				info.setBorder(BorderFactory.createEmptyBorder());
				edgeNonConfPanel.add(info);
			}
			
			
			border.setTitleColor(Color.black);
		}
		else {
			edgeNonConfPanel.removeAll();
			JPanel textPanel = new JPanel(new GridLayout());
			textPanel.setEnabled(false);
//			JLabel info = new JLabel(
//					"<html>&nbsp;&nbsp;Switch to Detailed Links&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
//							+ "<br>&nbsp;&nbsp;in the View menu<br>&nbsp;&nbsp;or press the button above<br>&nbsp;&nbsp;to use this box.</html>");
//			info.setForeground(Color.gray);
//			textPanel.add(info);
			edgeNonConfPanel.add(textPanel);
			
			border.setTitleColor(Color.gray);
		}
		edgeNonConfPanel.setBorder(border);
	}
	
	/**
	 * Mouse Wheel Event for class
	 */
	public void mouseWheelMoved(MouseWheelEvent e) {
		int notches = e.getWheelRotation();
		scalerSlider.removeChangeListener(this);

	    //event bounded to scaling
		if (e.getScrollType() == MouseWheelEvent.WHEEL_UNIT_SCROLL) { 
			double scale;

			scale = (scalerSlider.getValue() * 0.01) - (0.1 * notches);

			scale = Math.min(Math.max(0.1, scale), 5.0);
			
			//when the event is fired by the panel, the mouse position 
			//indcates the center of the scaling - otherwise it is the center of the panel
			if (e.getSource() == panel)
				lastPosOnMouseWheelScroll = e.getPoint();
			((JSquidPanel) panel).rescaleNodes(scale / prevScale);
			lastPosOnMouseWheelScroll = null;

			// //reduces 'jumping' of the graph on a small scaling factor
			// if (scale < 1.0 && scale > 0.1)
			// ((JSquidPanel) panel).moveNodes(-10, -10);

			scalerSlider.setValue(Math.round((float) scale * 100));
			overviewPanel.resizeOverviewRect(scale);
			overviewPanel.repaint();

			prevScale = scale;
		}

		scalerSlider.addChangeListener(this);
		// performTooltipInvokeClick();

	}
	
	public Point getLastPosOnMouseWheelScroll() {
		return this.lastPosOnMouseWheelScroll;
	}

	/**
	 * search Upated event for class
	 */
	public void searchUpdateOccurred(SearchPanelEvent event) {
		if (event.getSource() == searchField) { // SearchField event (node/s has
												// been found)
			panel.getGraph().setHitNodes(searchField.getListOfHits());
			panel.repaint();
		}
	}

	/**
	 * @return the searchField
	 */
	public JSearchPanel getSearchField() {
		return searchField;
	}

	/**
	 * Disable or enable GroupMenu
	 * 
	 * @param enable
	 *            on or off
	 */
	public void switchVisibilityGroupButton(boolean enable) {
		groupMenu.setEnabled(enable);
	}

	/**
	 * Gets the applet info
	 */
	public String getAppletInfo() {
		return "Title: JSquid \nAuthors: Martin Klammer and Sanjit Roopra";
	}

	/**
	 * Nice hack to gain tooltip text after losing focus
	 */
	public void performTooltipInvokeAction() {
		confidenceSlider.requestFocus();

	}

}
