/**
 * ExportToGIF.java
 */
package jsquid.picture;

import java.awt.Color;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;


/**
 * @author sanjit
 * Implementation of Exporter for GIF Format
 */
public class ExportToGIF extends Exporter {

	public ExportToGIF(String xmlInput, int width, int height, String filename, String style, String interactionType) {
		super(xmlInput,width,height,filename,style, interactionType);
	}

	public OutputStream doExport() throws IOException {
		BufferedImage awtImage = new BufferedImage(width, height,
				BufferedImage.TYPE_INT_ARGB);
		Graphics2D g = awtImage.createGraphics();
		g.setColor(Color.white);
		g.fillRect(0, 0, width, height);

		panel.paintNet(g);

		OutputStream stream = null;
		//Choose between File or StdOut
		if(filename != null)
			stream = new FileOutputStream(filename);
		else {
			stream = new ByteArrayOutputStream();
			toSysOut = true;
		}
		ImageIO.write(awtImage, "gif", stream);
		
		return stream;
	}
}

