/**
 * JSquidSAXWriter.java
 */
package jsquid.convert.writers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import medusa.MedusaSettings;
import medusa.graph.Edge;
import medusa.graph.Node;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/**
 * @author sanjit
 * JSquid SAX Writer version of XMLSAXWriter
 */
public class JSquidSAXWriter extends XMLSAXWriter {

	public JSquidSAXWriter(String filename, HashMap nodes, ArrayList edges,
			MedusaSettings settings) {
		super(filename, nodes, edges, settings);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jsquid.writers.XMLSAXWriter#doWriteXML()
	 */
	protected void doWriteXML() throws Exception {
		AttributesImpl atts = new AttributesImpl();
		atts.addAttribute(null, null, "x", null, JSquidConstants.XSIZE);
		atts.addAttribute(null, null, "y", null, JSquidConstants.YSIZE);
		hd.startElement("", "", JSquidConstants.STARTELEMENT, atts);

		createInteractionElements();
		createEdgeElements();
		createNodeElements();

		hd.endElement("", "", JSquidConstants.STARTELEMENT);

	}

	/**
	 * Creates Edge Elements in XML File
	 * @throws SAXException
	 */
	private void createEdgeElements() throws SAXException {
		hd.startElement("", "", JSquidConstants.EDGESELEMENT, new AttributesImpl());
		for (Iterator iterEdge = getEdges().iterator(); iterEdge.hasNext();) {
			Edge e = (Edge) iterEdge.next();

			AttributesImpl attEdge = new AttributesImpl();
			attEdge.addAttribute(null, null, "n1", null, e.n1);
			attEdge.addAttribute(null, null, "n2", null, e.n2);
			//attEdge.addAttribute(null, null, "iType", null, Integer.toString(e.getType()));
			attEdge.addAttribute(null, null, "iType", null, "0");
			attEdge.addAttribute(null, null, "conf", null, Float.toString(e.getConf()));
			attEdge.addAttribute(null, null, "ortn", null, Double.toString(e.getOrientation()));

			hd.startElement("", "", JSquidConstants.EDGEELEMENT, attEdge);

			hd.endElement("", "", JSquidConstants.EDGEELEMENT);

		}
		hd.endElement("", "", JSquidConstants.EDGESELEMENT);

	}

	/**
	 * Creates Node Elements in XML File
	 * @throws SAXException
	 */
	private void createNodeElements() throws SAXException {
		hd.startElement("", "", JSquidConstants.NODESELEMENT, new AttributesImpl());
		for (Iterator iterNode = getNodes().values().iterator(); iterNode.hasNext();) {
			Node node = (Node) iterNode.next();

			AttributesImpl attNode = new AttributesImpl();
			attNode.addAttribute(null, null, "name", null, node.getLabel());
			attNode.addAttribute(null, null, "x", null, Double.toString(node.getX()));
			attNode.addAttribute(null, null, "y", null, Double.toString(node.getY()));
			attNode.addAttribute(null, null, "color", null, convertColorToRGBString(node.getColor()));
			attNode.addAttribute(null, null, "shape", null, Integer.toString(node.getShape()));
			attNode.addAttribute(null, null, "size", null, Integer.toString(node.getNodeSize()));

			hd.startElement("", "", JSquidConstants.NODEELEMENT, attNode);
			if(node.getAnnotation().length() > 0){
				hd.startElement("", "", JSquidConstants.ANNOTATIONELEMENT, new AttributesImpl());
				hd.characters(node.getAnnotation().toCharArray(), 0, node.getAnnotation().length());
				hd.endElement("", "", JSquidConstants.ANNOTATIONELEMENT);
			}
			hd.endElement("", "", JSquidConstants.NODEELEMENT);

		}
		hd.endElement("", "", JSquidConstants.NODESELEMENT);

	}

	/**
	 * Creates InteractionElements in JSquid XML File
	 * @throws SAXException
	 */
	private void createInteractionElements() throws SAXException {
		hd.startElement("", "", JSquidConstants.INTERACTIONELEMENT, new AttributesImpl());
		//Don't need any interaction types for a simple graph
		//all Interactions are in Evidence by Type
		/*hd.startElement("", "", JSquidConstants.TYPESELEMENT, new AttributesImpl());
		ArrayList keyList = new ArrayList(getSettings().getInteractionTable().keySet());
		Collections.sort(keyList);
		for (Iterator iterInteractions = keyList.iterator(); iterInteractions.hasNext();) {
			Integer key = (Integer) iterInteractions.next();
			Color color = getSettings().getColor(key);
			String interaction = getSettings().getName(key);
			if (color != null) {

				AttributesImpl attInteraction = new AttributesImpl();
				attInteraction.addAttribute(null, null, "ID", null, key.toString());
				attInteraction.addAttribute(null, null, "name", null, interaction);
				String colorString = convertColorToRGBString(color);
				attInteraction.addAttribute(null, null, "color", null, colorString);
				hd.startElement("", "", JSquidConstants.TYPEELEMENT, attInteraction);

				hd.endElement("", "", JSquidConstants.TYPEELEMENT);
			}

		}
		hd.endElement("", "", JSquidConstants.TYPESELEMENT);*/
		hd.endElement("", "", JSquidConstants.INTERACTIONELEMENT);

	}

	/**
	 * converts a Color to a String format red, green, blue
	 * @param color
	 * @return color as a string red,green,blue
	 */
	private String convertColorToRGBString(Color color) {
		return Integer.toString(color.getRed()) + ","
				+ Integer.toString(color.getGreen()) + ","
				+ Integer.toString(color.getBlue());
	}

}
