/**
 * XMLDOMReader.java
 */
package jsquid.convert.readers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import medusa.MedusaSettings;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * @author sanjit
 * Implementation of IXMLReader DOM Version
 */
public abstract class XMLDOMReader implements IXMLReader {

	protected HashMap nodes;	
	
	protected MedusaSettings settings;

	protected ArrayList edges;

	protected ArrayList usedNodeNames;
	
	private Document doc;
	
	private String xmlInput;
	
	
	public XMLDOMReader(String xmlInput){
		this.xmlInput = xmlInput;
		nodes = new HashMap();
		edges = new ArrayList();
		usedNodeNames = new ArrayList();
		settings = new MedusaSettings();
	}
	
	//template function
	public void readXML(){
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

		try {
			DocumentBuilder parser = factory.newDocumentBuilder();
			InputStream xmlStream = new ByteArrayInputStream(xmlInput.getBytes());
			doc = parser.parse(xmlStream);
			doReadXML();
			xmlStream.close();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected abstract void doReadXML() throws Exception;

	/**
	 * @return the xmlInput
	 */
	public String getXmlInput() {
		return xmlInput;
	}

	/**
	 * @return the doc
	 */
	public Document getDoc() {
		return doc;
	}

	/**
	 * @return the edges
	 */
	public ArrayList getEdges() {
		return edges;
	}

	/**
	 * @return the nodes
	 */
	public HashMap getNodes() {
		return nodes;
	}

	/**
	 * @return the settings
	 */
	public MedusaSettings getSettings() {
		return settings;
	}
}
