/**
 * XGMMLDOMReader.java
 */
package jsquid.convert.readers;

import java.awt.Color;
import java.util.ArrayList;

import medusa.graph.Edge;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author sanjit XGMML DOM Reader Version of XMLDOMReader Reads XGMML File and
 *         saves data JSquid readable
 */
public class XGMMLDOMReader extends XMLDOMReader {

	private static final int INITIAL_POS_MULTIPLIER = 600;

	public XGMMLDOMReader(String xmlInput) {
		super(xmlInput);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jsquid.readers.XMLDOMReader#doReadXML()
	 */
	protected void doReadXML() throws Exception {
		loadNodes();
		loadEdgesAndInteractions();
	}

	private void loadEdgesAndInteractions() throws Exception {
		NodeList nodeList = getDoc().getElementsByTagName("edge");
		ArrayList firstNodeList = new ArrayList();
		int interactionType = 1;
		for (int i = 0; i < nodeList.getLength(); i++) {
			Node nodeEdge = nodeList.item(i);
			NamedNodeMap map = nodeEdge.getAttributes();

			Node attEdgeSource = map.getNamedItem("source");
			Integer source = Integer.valueOf(attEdgeSource.getNodeValue());

			Node attEdgeTarget = map.getNamedItem("target");
			Integer target = Integer.valueOf(attEdgeTarget.getNodeValue());

			Node attEdgeWeight = map.getNamedItem("weight");
			Float weight = null;
			if (attEdgeWeight != null)
				weight = Float.valueOf(attEdgeWeight.getNodeValue());

			String interaction = "undefined";
			Color interactionColor = Color.red;

			NodeList elements = nodeEdge.getChildNodes();
			for (int j = 0; j < elements.getLength(); j++) {
				Node element = elements.item(j);
				if (element.getNodeName().equals(XGMMLConstants.ATT)) {
					NamedNodeMap attMap = element.getAttributes();
					if (attMap.getNamedItem("name").getNodeValue()
							.equalsIgnoreCase(XGMMLConstants.EDGETOOLTIP)) {
						Node attValue = attMap.getNamedItem("value");
						if (weight == null && attValue != null) {
							try {
								weight = Float.valueOf(attValue.getNodeValue());
							} catch (NumberFormatException e) {
							}
						}
					} else if (attMap.getNamedItem("name").getNodeValue()
							.equalsIgnoreCase(XGMMLConstants.INTERACTION)) {
						Node attValue = attMap.getNamedItem("value");
						if (attValue != null)
							interaction = attValue.getNodeValue();
					}
				} else if (element.getNodeName().equals(
						XGMMLConstants.GRAPHICSELEMENT)) {
					NamedNodeMap graphicsMap = element.getAttributes();
					interactionColor = Color.RED;
					try {
						interactionColor = Color.decode(graphicsMap
								.getNamedItem("fill").getNodeValue());
					} catch (Exception e) {

					}
				}

			}
			if (!settings.containsName(interaction)) {
				settings.setName(new Integer(interactionType), interaction);
				settings.setColor(new Integer(interactionType),
						interactionColor);
				++interactionType;
			}

			String node1 = ((medusa.graph.Node) nodes.get(source)).getLabel();
			String node2 = ((medusa.graph.Node) nodes.get(target)).getLabel();
			int type = settings.getIndexOfName(interaction);
			if (firstNodeList.contains(node2 + node1)) {
				String h = node2;
				node2 = node1;
				node1 = h;
			} else if (!firstNodeList.contains(node1 + node2))
				firstNodeList.add(node1 + node2);

			double orientation = calculateOrientation(type - 1);

			float conf = 0.0F;
			if (weight != null)
				conf = weight.floatValue();
			if(node1.equals(node2))
				orientation = 1.0;
			Edge e = new Edge(node1, node2, conf, type, orientation);
			edges.add(e);
		}

	}

	private double calculateOrientation(int type) {
		int calcType = type;
		if (type % 2 != 0)
			calcType += 1;
		calcType /= 2;
		double orientation = calcType * 0.5;
		if (type % 2 != 0)
			orientation *= -1;
		return orientation;
	}

	/**
	 * Reads the node from the XGMML File
	 * 
	 * @throws Exception
	 */
	private void loadNodes() throws Exception {
		NodeList nodeList = getDoc().getElementsByTagName("node");
		// Iterate over all nodes in XML File
		for (int i = 0; i < nodeList.getLength(); i++) {
			Node nodeNode = nodeList.item(i);
			NamedNodeMap map = nodeNode.getAttributes();

			// get ID
			Node attNodeID = map.getNamedItem("id");
			Integer id = Integer.valueOf(attNodeID.getNodeValue());

			// get Label
			Node attNodeLabel = map.getNamedItem("label");
			String label = attNodeLabel.getNodeValue();

			String annotation = "";
			double size = 0;
			double x = 0;
			double y = 0;
			Color nodeColor = Color.red;

			// Read childNodes
			NodeList elements = nodeNode.getChildNodes();
			for (int j = 0; j < elements.getLength(); j++) {
				Node element = elements.item(j);
				if (element.getNodeName().equals(XGMMLConstants.ATT)) {
					NamedNodeMap attMap = element.getAttributes();
					if (attMap.getNamedItem("name").getNodeValue()
							.equalsIgnoreCase(XGMMLConstants.NODETOOLTIP)) {
						Node attValue = attMap.getNamedItem("value");
						if (attValue != null)
							annotation = attValue.getNodeValue();
					}
				} else if (element.getNodeName().equals(
						XGMMLConstants.GRAPHICSELEMENT)) {
					NamedNodeMap graphicsMap = element.getAttributes();
					size = 1;
					try {
						size = Double.parseDouble(graphicsMap.getNamedItem("w")
								.getNodeValue());
						size = Math.min(size, 50);
						size = (size - 32) / 2;
					} catch (Exception e) {

					}
					x = 0.5;
					y = 0.5;
					try {
						x = Double.parseDouble(graphicsMap.getNamedItem("x")
								.getNodeValue());
						x = Math.min(x, 600);
						x /= INITIAL_POS_MULTIPLIER;
						y = Double.parseDouble(graphicsMap.getNamedItem("y")
								.getNodeValue());
						y = Math.min(y, 600);
						y /= INITIAL_POS_MULTIPLIER;
					} catch (Exception e) {

					}

					nodeColor = Color.GRAY;
					try {
						nodeColor = Color.decode(graphicsMap.getNamedItem(
								"fill").getNodeValue());
					} catch (Exception e) {

					}

				}
			}

			// every node should have a different Name
			if (usedNodeNames.contains(label)) {
				label += "." + i;
			}
			usedNodeNames.add(label);
			medusa.graph.Node medusaNode = new medusa.graph.Node(label, x, y,
					nodeColor, annotation);
			medusaNode.setNodeSize((int) size);
			nodes.put(id, medusaNode);
		}
	}

}
