// Medusa is a graph viewer which allows interactive editing of networks
// (edges and nodes) and also connects to databases.
//
// Copyright (C) 2006 Sean Hooper
//
// This program is free software; you can redistribute it and/or modify 
// it under the terms of the GNU General Public License as published by 
// the Free Software Foundation; either version 2 of the License, or (at 
// your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General 
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the 
// Free Software Foundation, Inc., 
// 59 Temple Place, Suite 330, 
// Boston, MA 02111-1307 USA

package medusa.applet;

//import TimeNet.Stringlet;
import java.awt.BorderLayout;
import java.awt.Graphics;
import javax.swing.JApplet;
import java.awt.event.ItemListener;
import java.awt.Color;
import javax.swing.JScrollPane;
import javax.swing.JPanel;
import javax.swing.JCheckBox;
import javax.swing.JButton;
import javax.swing.JSlider;

import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.Container;

import medusa.*;
import medusa.display.BasicGraphPanel;



/**
 * <code>MedusaLite</code> is an applet version of medusa.
 * The parameters required are very strict, since the applet will probably be used
 * as a complement to a webserver and the data will be generated by scripts.
 *
 *
 * <code>
 * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
 * <html>
 * <head>
 *  <title>Network</title>
 * </head>
 * <body>
 * <h1>Lightweight network viewer</h1>
 * <hr> <applet code="medusa.applet.MedusaLite.class"
 * archive="medusa.jar" height="600" width="600">
 * <param name="settings" value="0,0,0;100,255,100">
 *
 * <param name="edges" value=
 * "nodeA:node2:2:1:1.0;node1:node3:2:1:0.0;node1:node2:1:1:-1.0;">
 *
 * <param name="nodes" value="nodeA:0.5:0.5:34,34,34:1;node2:0.8:0.4:234,234,34:2;">
 *
 * <param name="X" value="500"><param
 * name="Y" value="500"> </applet> <br>
 * </body>
 * </html></code>
 * @author <a href="mailto:hooper@minie.EMBL-Heidelberg.DE">Sean Hooper</a>
 * @version 1.0
 */
public class MedusaLite extends JApplet
        implements ItemListener{
    
	protected boolean stayAlive = true;
    final Color christian=new Color(230,226,230);
    public BasicGraphPanel panel;
    private MedusaSettings stringSettings;
    //InfoPanel infoPanel;
    private JScrollPane jScrollPane;
    //Image image;
    public JPanel controlPanel = new JPanel();
    private int xParam;
    private int yParam;
    protected JCheckBox relax =new JCheckBox("Relax",false);
    protected JCheckBox pretty =new JCheckBox("Edge colours",true);
    protected JCheckBox names = new JCheckBox("Labels", true);
    protected JButton imageButton = new JButton("Export");
    //protected String nodeTypes;
    protected JSlider scalerSlider = new JSlider(JSlider.HORIZONTAL, 0, 500, 100);
   
    public void initPanel(){
       if (stayAlive) {
    	   System.out.println("Initializing MedusaAppletPanel");
    	   String settingsParam=getParameter("settings");
        
    	   setStringSettings(new MedusaSettings(settingsParam));
       }

    }
    
    
    public void init(){
        initPanel();
        if (stayAlive) {
			Container content = getContentPane();
			content.setLayout(new BorderLayout());

			System.out.print("Panel is ");
			if (getPanel() == null)
				System.out.println("null");
			else
				System.out.println("not null");
			// getPanel().setGraph(g);
			System.out.println("Graph loaded");

			//setPrefs();
			setXParam(getParameter("X") == null ? 400 : Integer
					.parseInt(getParameter("X")));
			setYParam(getParameter("Y") == null ? 400 : Integer
					.parseInt(getParameter("Y")));

			getPanel().setSize(getXParam(), getYParam());
			getPanel().setTimeFrameXY(getPanel().getWidth(),
					getPanel().getHeight());
			setJScrollPane(new JScrollPane(getPanel()));
			content.add("Center", getJScrollPane());

			controlPanel = new JPanel();
			populateControlPanel();

			content.add("South", controlPanel);
			System.out.println("Setting visible");
			// pack();
			// setSize(xParam,yParam+controlPanel.getHeight());

			setVisible(true);
			// panel.validate();

			getJScrollPane().validate();

			String layoutParam = getParameter("layout");
			if (layoutParam != null) {
				if (layoutParam.compareTo("true") == 0) {
					getPanel().energy();
				}
			}
		}
        
    }
    
    public void setPrefs(){
        // netPanel.setImage(image);
        getPanel().setPretty(false);
        getPanel().setArrows(false);
        getPanel().setLabel(true);
        getPanel().setConfidence(true);
        getPanel().setCool(true);
        getPanel().repaint();
        
    }
    
    public void populateControlPanel(){
        FlowLayout layout = new FlowLayout(FlowLayout.LEFT);
    	controlPanel.setLayout(layout);
        
    }
    
    
    public void destroy() {
        //netPanel.stop();
        if (panel != null)
        	remove(panel);
        
    }

    
    public String getAppletInfo(){
        return "Title: MedusaLite \nAuthor: Sean Hooper";
    }
    

    /*
     * Handle item state changes
     */
    public void itemStateChanged(ItemEvent e){
        Object src = e.getSource();
        if (src==relax){
            if (relax.isSelected()){
                getPanel().start();
                //panel.energy();
            } else
                getPanel().stop();
        }
        if (src == pretty){
            getPanel().setPretty(pretty.isSelected());
            getPanel().repaint();
        }
        if (src == names){
            getPanel().setLabel(names.isSelected());
            getPanel().repaint();
        }
    }

    /**
     * 
     * Paints the container. This forwards the paint to any lightweight
     * components that are children of this container. If this method is
     * reimplemented, super.paint(g) should be called so that lightweight
     * components are properly rendered. If a child component is entirely
     * clipped by the current clipping setting in g, paint() will not be
     * forwarded to that child.
     * 
     * @param g the specified Graphics window
     * @see Component#update(Graphics)
     */
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void setStringSettings(MedusaSettings stringSettings) {
        this.stringSettings = stringSettings;
    }

    public void setPanel(BasicGraphPanel panel) {
        this.panel = panel;
    }

    public BasicGraphPanel getPanel() {
        return panel;
    }

    public int getXParam() {
        return xParam;
    }

    public void setXParam(int xParam) {
        this.xParam = xParam;
    }

    public int getYParam() {
        return yParam;
    }

    public void setYParam(int yParam) {
        this.yParam = yParam;
    }

    public MedusaSettings getStringSettings() {
        return stringSettings;
    }

    public JScrollPane getJScrollPane() {
        return jScrollPane;
    }

    public void setJScrollPane(JScrollPane jScrollPane) {
        this.jScrollPane = jScrollPane;
    }
    
    
}

